/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.delegate;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Filter;
import com.avaje.ebean.Query;
import com.avaje.ebean.SqlQuery;
import com.avaje.ebean.delegate.DelegateOrmQuery;
import java.util.Set;

public class DelegateQuery {
    protected EbeanServer delegate;
    protected EbeanServer owner;

    public DelegateQuery(EbeanServer delegate, EbeanServer owner) {
        this.delegate = delegate;
        this.owner = owner;
    }

    public <T> Query<T> delegateToThisServer(Query<T> sourceQuery) {
        return DelegateOrmQuery.copy(sourceQuery, this.owner);
    }

    public <T> Query<T> createQuery(Class<T> beanType) {
        return this.delegateToThisServer(this.delegate.createQuery(beanType));
    }

    public <T> Query<T> find(Class<T> beanType) {
        return this.delegateToThisServer(this.delegate.find(beanType));
    }

    public <T> Filter<T> filter(Class<T> beanType) {
        return this.delegate.filter(beanType);
    }

    public SqlQuery createSqlQuery(String sql) {
        return this.delegate.createSqlQuery(sql);
    }

    public <T> T getReference(Class<T> beanType, Object id) {
        return (T)this.delegate.getReference(beanType, id);
    }

    public <T> Set<String> validateQuery(Query<T> query) {
        return this.delegate.validateQuery(query);
    }

    public <T> Query<T> createQuery(Class<T> beanType, String eql) {
        return this.delegate.createQuery(beanType, eql);
    }

    public <T> Query<T> createNamedQuery(Class<T> beanType, String namedQuery) {
        return this.delegate.createNamedQuery(beanType, namedQuery);
    }
}

