/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery;

import com.avaje.ebean.ExpressionList;
import org.avaje.ebean.typequery.TQPath;
import org.avaje.ebean.typequery.TQProperty;
import org.avaje.ebean.typequery.TQRootBean;

public abstract class TQAssocBean<T, R> {
    protected final String _name;
    protected final R _root;

    public TQAssocBean(String name, R root) {
        this(name, root, null);
    }

    public TQAssocBean(String name, R root, String prefix) {
        this._root = root;
        this._name = TQPath.add(prefix, name);
    }

    public R fetchAll() {
        ((TQRootBean)this._root).query().fetch(this._name, "*");
        return this._root;
    }

    protected R fetchProperties(TQProperty<?> ... props) {
        StringBuilder selectProps = new StringBuilder(50);
        for (int i = 0; i < props.length; ++i) {
            if (i > 0) {
                selectProps.append(",");
            }
            selectProps.append(props[i].propertyName());
        }
        ((TQRootBean)this._root).query().fetch(this._name, selectProps.toString());
        return this._root;
    }

    protected ExpressionList<?> expr() {
        return ((TQRootBean)this._root).peekExprList();
    }

    public R equalTo(T other) {
        this.expr().eq(this._name, other);
        return this._root;
    }

    public R notEqualTo(T other) {
        this.expr().ne(this._name, other);
        return this._root;
    }

    public R filterMany(ExpressionList<T> filter) {
        ExpressionList expressionList = this.expr().filterMany(this._name);
        expressionList.addAll(filter);
        return this._root;
    }

    public R isEmpty() {
        this.expr().isEmpty(this._name);
        return this._root;
    }

    public R isNotEmpty() {
        this.expr().isNotEmpty(this._name);
        return this._root;
    }
}

