/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.util.StringHelper;
import java.util.Map;

public class DataSourceConfig {
    private String url;
    private String username;
    private String password;
    private String driver;
    private int minConnections = 2;
    private int maxConnections = 20;
    private int isolationLevel = 2;
    private String heartbeatSql;
    private int heartbeatFreqSecs = 30;
    private boolean captureStackTrace;
    private int maxStackTraceSize = 5;
    private int leakTimeMinutes = 30;
    private int maxInactiveTimeSecs = 900;
    private int pstmtCacheSize = 20;
    private int cstmtCacheSize = 20;
    private int waitTimeoutMillis = 1000;
    private String poolListener;
    private boolean offline;
    Map<String, String> customProperties;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getHeartbeatSql() {
        return this.heartbeatSql;
    }

    public void setHeartbeatSql(String heartbeatSql) {
        this.heartbeatSql = heartbeatSql;
    }

    public int getHeartbeatFreqSecs() {
        return this.heartbeatFreqSecs;
    }

    public void setHeartbeatFreqSecs(int heartbeatFreqSecs) {
        this.heartbeatFreqSecs = heartbeatFreqSecs;
    }

    public boolean isCaptureStackTrace() {
        return this.captureStackTrace;
    }

    public void setCaptureStackTrace(boolean captureStackTrace) {
        this.captureStackTrace = captureStackTrace;
    }

    public int getMaxStackTraceSize() {
        return this.maxStackTraceSize;
    }

    public void setMaxStackTraceSize(int maxStackTraceSize) {
        this.maxStackTraceSize = maxStackTraceSize;
    }

    public int getLeakTimeMinutes() {
        return this.leakTimeMinutes;
    }

    public void setLeakTimeMinutes(int leakTimeMinutes) {
        this.leakTimeMinutes = leakTimeMinutes;
    }

    public int getPstmtCacheSize() {
        return this.pstmtCacheSize;
    }

    public void setPstmtCacheSize(int pstmtCacheSize) {
        this.pstmtCacheSize = pstmtCacheSize;
    }

    public int getCstmtCacheSize() {
        return this.cstmtCacheSize;
    }

    public void setCstmtCacheSize(int cstmtCacheSize) {
        this.cstmtCacheSize = cstmtCacheSize;
    }

    public int getWaitTimeoutMillis() {
        return this.waitTimeoutMillis;
    }

    public void setWaitTimeoutMillis(int waitTimeoutMillis) {
        this.waitTimeoutMillis = waitTimeoutMillis;
    }

    public int getMaxInactiveTimeSecs() {
        return this.maxInactiveTimeSecs;
    }

    public void setMaxInactiveTimeSecs(int maxInactiveTimeSecs) {
        this.maxInactiveTimeSecs = maxInactiveTimeSecs;
    }

    public String getPoolListener() {
        return this.poolListener;
    }

    public void setPoolListener(String poolListener) {
        this.poolListener = poolListener;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public void loadSettings(String serverName) {
        this.loadSettingsCustomPrefix("datasource." + serverName + ".", new GlobalProperties.DelegatedGlobalPropertySource(serverName));
    }

    public void loadSettingsCustomPrefix(String prefix, GlobalProperties.PropertySource properties) {
        this.username = properties.get(prefix + "username", null);
        this.password = properties.get(prefix + "password", null);
        String v = properties.get(prefix + "databaseDriver", null);
        this.driver = properties.get(prefix + "driver", v);
        v = properties.get(prefix + "databaseUrl", null);
        this.url = properties.get(prefix + "url", v);
        this.captureStackTrace = properties.getBoolean(prefix + "captureStackTrace", false);
        this.maxStackTraceSize = properties.getInt(prefix + "maxStackTraceSize", 5);
        this.leakTimeMinutes = properties.getInt(prefix + "leakTimeMinutes", 30);
        this.maxInactiveTimeSecs = properties.getInt(prefix + "maxInactiveTimeSecs", 900);
        this.minConnections = properties.getInt(prefix + "minConnections", 0);
        this.maxConnections = properties.getInt(prefix + "maxConnections", 20);
        this.pstmtCacheSize = properties.getInt(prefix + "pstmtCacheSize", 20);
        this.cstmtCacheSize = properties.getInt(prefix + "cstmtCacheSize", 20);
        this.waitTimeoutMillis = properties.getInt(prefix + "waitTimeout", 1000);
        this.heartbeatSql = properties.get(prefix + "heartbeatSql", null);
        this.poolListener = properties.get(prefix + "poolListener", null);
        this.offline = properties.getBoolean(prefix + "offline", false);
        String isoLevel = properties.get(prefix + "isolationlevel", "READ_COMMITTED");
        this.isolationLevel = this.getTransactionIsolationLevel(isoLevel);
        String customProperties = properties.get(prefix + "customProperties", null);
        if (customProperties != null && customProperties.length() > 0) {
            Map<String, String> custProps = StringHelper.delimitedToMap(customProperties, ";", "=");
            this.customProperties = custProps;
        }
    }

    public int getTransactionIsolationLevel(String level) {
        if ((level = level.toUpperCase()).startsWith("TRANSACTION")) {
            level = level.substring("TRANSACTION".length());
        }
        if ("NONE".equalsIgnoreCase(level = level.replace("_", ""))) {
            return 0;
        }
        if ("READCOMMITTED".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("READUNCOMMITTED".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("REPEATABLEREAD".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("SERIALIZABLE".equalsIgnoreCase(level)) {
            return 8;
        }
        throw new RuntimeException("Transaction Isolaction level [" + level + "] is not known.");
    }
}

