/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebeaninternal.server.core.BootupClasses;
import com.avaje.ebeaninternal.server.util.ClassPathSearch;
import com.avaje.ebeaninternal.server.util.ClassPathSearchFilter;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootupClassPathSearch {
    private static final Logger logger = LoggerFactory.getLogger(BootupClassPathSearch.class);
    private final Object monitor = new Object();
    private final ClassLoader classLoader;
    private final List<String> packages;
    private final List<String> jars;
    private BootupClasses bootupClasses;

    public BootupClassPathSearch(ClassLoader classLoader, List<String> packages, List<String> jars) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.packages = packages;
        this.jars = jars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootupClasses getBootupClasses() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bootupClasses == null) {
                this.bootupClasses = this.search();
            }
            return this.bootupClasses;
        }
    }

    private BootupClasses search() {
        Object object = this.monitor;
        synchronized (object) {
            try {
                BootupClasses bc = new BootupClasses();
                long st = System.currentTimeMillis();
                ClassPathSearchFilter filter = this.createFilter();
                ClassPathSearch finder = new ClassPathSearch(this.classLoader, filter, bc);
                finder.findClasses();
                Set<String> jars = finder.getJarHits();
                Set<String> pkgs = finder.getPackageHits();
                long searchTime = System.currentTimeMillis() - st;
                String msg = "Classpath search hits in jars" + jars + " pkgs" + pkgs + "  searchTime[" + searchTime + "]";
                logger.info(msg);
                return bc;
            }
            catch (Exception ex) {
                String msg = "Error in classpath search (looking for entities etc)";
                throw new RuntimeException(msg, ex);
            }
        }
    }

    private ClassPathSearchFilter createFilter() {
        ClassPathSearchFilter filter = new ClassPathSearchFilter();
        filter.addDefaultExcludePackages();
        if (this.packages != null) {
            for (String packageName : this.packages) {
                filter.includePackage(packageName);
            }
        }
        if (this.jars != null) {
            for (String jarName : this.jars) {
                filter.includeJar(jarName);
            }
        }
        return filter;
    }
}

