/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.server.lib.DaemonScheduleThreadPool;
import com.avaje.ebeaninternal.server.lib.thread.ThreadPool;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraditionalBackgroundExecutor
implements SpiBackgroundExecutor {
    private static Logger logger = LoggerFactory.getLogger(TraditionalBackgroundExecutor.class);
    private final ThreadPool pool;
    private final DaemonScheduleThreadPool schedulePool;

    public TraditionalBackgroundExecutor(ThreadPool pool, int schedulePoolSize, int shutdownWaitSeconds, String namePrefix) {
        this.pool = pool;
        this.schedulePool = new DaemonScheduleThreadPool(schedulePoolSize, shutdownWaitSeconds, namePrefix + "-periodic-");
    }

    @Override
    public void execute(Runnable r) {
        this.pool.assign(r, true);
    }

    @Override
    public void executePeriodically(Runnable r, long delay, TimeUnit unit) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering for executePeriodically {} delay:{} {}", new Object[]{r, delay, unit});
        }
        this.schedulePool.scheduleWithFixedDelay(r, delay, delay, unit);
    }

    @Override
    public void shutdown() {
        if (logger.isDebugEnabled()) {
            logger.debug("Shutting down");
        }
        this.pool.shutdown();
        this.schedulePool.shutdown();
    }
}

