/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.jmx;

import com.avaje.ebean.AdminAutofetch;
import com.avaje.ebean.config.AutofetchMode;
import com.avaje.ebeaninternal.server.autofetch.AutoFetchManager;
import com.avaje.ebeaninternal.server.jmx.MAdminAutofetchMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MAdminAutofetch
implements MAdminAutofetchMBean,
AdminAutofetch {
    private static final Logger logger = LoggerFactory.getLogger(MAdminAutofetch.class);
    final AutoFetchManager autoFetchManager;
    final String modeOptions;

    public MAdminAutofetch(AutoFetchManager autoFetchListener) {
        this.autoFetchManager = autoFetchListener;
        this.modeOptions = (Object)((Object)AutofetchMode.DEFAULT_OFF) + ", " + (Object)((Object)AutofetchMode.DEFAULT_ON) + ", " + (Object)((Object)AutofetchMode.DEFAULT_ONIFEMPTY);
    }

    @Override
    public boolean isQueryTuning() {
        return this.autoFetchManager.isQueryTuning();
    }

    @Override
    public void setQueryTuning(boolean enable) {
        this.autoFetchManager.setQueryTuning(enable);
    }

    @Override
    public boolean isProfiling() {
        return this.autoFetchManager.isProfiling();
    }

    @Override
    public void setProfiling(boolean enable) {
        this.autoFetchManager.setProfiling(enable);
    }

    @Override
    public String getModeOptions() {
        return this.modeOptions;
    }

    @Override
    public String getMode() {
        return this.autoFetchManager.getMode().name();
    }

    @Override
    public void setMode(String implicitMode) {
        try {
            AutofetchMode mode = AutofetchMode.valueOf(implicitMode);
            this.autoFetchManager.setMode(mode);
        }
        catch (Exception e) {
            logger.info("Invalid implicit mode attempted " + e.getMessage());
        }
    }

    @Override
    public String collectUsageViaGC() {
        return this.autoFetchManager.collectUsageViaGC(-1L);
    }

    @Override
    public double getProfilingRate() {
        return this.autoFetchManager.getProfilingRate();
    }

    @Override
    public void setProfilingRate(double rate) {
        this.autoFetchManager.setProfilingRate(rate);
    }

    @Override
    public int getProfilingMin() {
        return this.autoFetchManager.getProfilingMin();
    }

    @Override
    public int getProfilingBase() {
        return this.autoFetchManager.getProfilingBase();
    }

    @Override
    public void setProfilingMin(int profilingMin) {
        this.autoFetchManager.setProfilingMin(profilingMin);
    }

    @Override
    public void setProfilingBase(int profilingMax) {
        this.autoFetchManager.setProfilingBase(profilingMax);
    }

    @Override
    public String updateTunedQueryInfo() {
        return this.autoFetchManager.updateTunedQueryInfo();
    }

    @Override
    public int clearProfilingInfo() {
        return this.autoFetchManager.clearProfilingInfo();
    }

    @Override
    public int clearTunedQueryInfo() {
        return this.autoFetchManager.clearTunedQueryInfo();
    }

    @Override
    public void clearQueryStatistics() {
        this.autoFetchManager.clearQueryStatistics();
    }

    @Override
    public int getTotalProfileSize() {
        return this.autoFetchManager.getTotalProfileSize();
    }

    @Override
    public int getTotalTunedQueryCount() {
        return this.autoFetchManager.getTotalTunedQueryCount();
    }

    @Override
    public int getTotalTunedQuerySize() {
        return this.autoFetchManager.getTotalTunedQuerySize();
    }
}

