/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.resource;

import com.avaje.ebeaninternal.server.lib.resource.AbstractResourceSource;
import com.avaje.ebeaninternal.server.lib.resource.FileResourceContent;
import com.avaje.ebeaninternal.server.lib.resource.ResourceContent;
import com.avaje.ebeaninternal.server.lib.resource.ResourceSource;
import java.io.File;

public class FileResourceSource
extends AbstractResourceSource
implements ResourceSource {
    String directory;
    String baseDir;

    public FileResourceSource(String directory) {
        this.directory = directory;
        this.baseDir = directory + File.separator;
    }

    public FileResourceSource(File dir) {
        this(dir.getPath());
    }

    @Override
    public String getRealPath() {
        return this.directory;
    }

    @Override
    public ResourceContent getContent(String entry) {
        String fullPath = this.baseDir + entry;
        File f = new File(fullPath);
        if (f.exists()) {
            FileResourceContent content = new FileResourceContent(f, entry);
            return content;
        }
        return null;
    }
}

