/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.sql;

import com.avaje.ebeaninternal.jdbc.PreparedStatementDelegator;
import com.avaje.ebeaninternal.server.lib.sql.PooledConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public abstract class ExtendedStatement
extends PreparedStatementDelegator {
    protected final PooledConnection pooledConnection;
    protected final PreparedStatement pstmt;

    public ExtendedStatement(PooledConnection pooledConnection, PreparedStatement pstmt) {
        super(pstmt);
        this.pooledConnection = pooledConnection;
        this.pstmt = pstmt;
    }

    @Override
    public abstract void close() throws SQLException;

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.pstmt.getConnection();
        }
        catch (SQLException e) {
            this.pooledConnection.addError(e);
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            this.pstmt.addBatch(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.addError(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            return this.pstmt.execute(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.addError(e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            return this.pstmt.executeQuery(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.addError(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.pooledConnection.setLastStatement(sql);
            return this.pstmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.pooledConnection.addError(e);
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.pstmt.executeBatch();
    }

    @Override
    public void cancel() throws SQLException {
        this.pstmt.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.pstmt.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.pstmt.clearWarnings();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.pstmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.pstmt.getFetchSize();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.pstmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.pstmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.pstmt.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.pstmt.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.pstmt.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.pstmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.pstmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.pstmt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.pstmt.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.pstmt.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.pstmt.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.pstmt.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.pstmt.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.pstmt.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.pstmt.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.pstmt.setQueryTimeout(seconds);
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this.pstmt.getMoreResults(i);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.pstmt.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        return this.pstmt.executeUpdate(s, i);
    }

    @Override
    public int executeUpdate(String s, int[] i) throws SQLException {
        return this.pstmt.executeUpdate(s, i);
    }

    @Override
    public int executeUpdate(String s, String[] i) throws SQLException {
        return this.pstmt.executeUpdate(s, i);
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        return this.pstmt.execute(s, i);
    }

    @Override
    public boolean execute(String s, int[] i) throws SQLException {
        return this.pstmt.execute(s, i);
    }

    @Override
    public boolean execute(String s, String[] i) throws SQLException {
        return this.pstmt.execute(s, i);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.pstmt.getResultSetHoldability();
    }
}

