/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.PrimaryServer;
import com.avaje.ebean.common.BootupEbeanManager;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.ServerConfig;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.persistence.PersistenceException;

public class EbeanServerFactory {
    private static BootupEbeanManager bootupEbeanManager;

    public static synchronized void initialiseContainer(ContainerConfig containerConfig) {
        EbeanServerFactory.getServerFactory(containerConfig);
    }

    public static synchronized EbeanServer create(String name) {
        BootupEbeanManager serverFactory = EbeanServerFactory.getServerFactory(null);
        return serverFactory.createServer(name);
    }

    public static synchronized EbeanServer create(ServerConfig config) {
        if (config.getName() == null) {
            throw new PersistenceException("The name is null (it is required)");
        }
        EbeanServer server = EbeanServerFactory.createInternal(config);
        if (config.isDefaultServer()) {
            PrimaryServer.setSkip(true);
        }
        if (config.isRegister()) {
            Ebean.register(server, config.isDefaultServer());
        }
        return server;
    }

    private static EbeanServer createInternal(ServerConfig config) {
        return EbeanServerFactory.getServerFactory(config.getContainerConfig()).createServer(config);
    }

    private static BootupEbeanManager getServerFactory(ContainerConfig containerConfig) {
        if (bootupEbeanManager != null) {
            return bootupEbeanManager;
        }
        if (containerConfig == null) {
            Properties properties = PrimaryServer.getProperties();
            containerConfig = new ContainerConfig();
            containerConfig.loadFromProperties(properties);
        }
        bootupEbeanManager = EbeanServerFactory.createServerFactory(containerConfig);
        return bootupEbeanManager;
    }

    private static BootupEbeanManager createServerFactory(ContainerConfig containerConfig) {
        String dflt = "com.avaje.ebeaninternal.server.core.DefaultServerFactory";
        String implClassName = System.getProperty("ebean.serverfactory", dflt);
        try {
            Class<?> cls = Class.forName(implClassName);
            Constructor<?> constructor = cls.getConstructor(ContainerConfig.class);
            return (BootupEbeanManager)constructor.newInstance(containerConfig);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

