/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.AutofetchMode;
import com.avaje.ebean.config.PropertiesWrapper;

public class AutofetchConfig {
    private AutofetchMode mode = AutofetchMode.DEFAULT_ONIFEMPTY;
    private boolean queryTuning = false;
    private boolean queryTuningAddVersion = false;
    private boolean profiling = false;
    private int profilingMin = 1;
    private int profilingBase = 10;
    private double profilingRate = 0.05;
    private String logDirectory;
    private int profileUpdateFrequency = 60;
    private int garbageCollectionWait = 100;
    private boolean garbageCollectionOnShutdown;

    public AutofetchMode getMode() {
        return this.mode;
    }

    public void setMode(AutofetchMode mode) {
        this.mode = mode;
    }

    public boolean isQueryTuning() {
        return this.queryTuning;
    }

    public void setQueryTuning(boolean queryTuning) {
        this.queryTuning = queryTuning;
    }

    public boolean isQueryTuningAddVersion() {
        return this.queryTuningAddVersion;
    }

    public void setQueryTuningAddVersion(boolean queryTuningAddVersion) {
        this.queryTuningAddVersion = queryTuningAddVersion;
    }

    public boolean isProfiling() {
        return this.profiling;
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }

    public int getProfilingMin() {
        return this.profilingMin;
    }

    public void setProfilingMin(int profilingMin) {
        this.profilingMin = profilingMin;
    }

    public int getProfilingBase() {
        return this.profilingBase;
    }

    public void setProfilingBase(int profilingBase) {
        this.profilingBase = profilingBase;
    }

    public double getProfilingRate() {
        return this.profilingRate;
    }

    public void setProfilingRate(double profilingRate) {
        this.profilingRate = profilingRate;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public int getProfileUpdateFrequency() {
        return this.profileUpdateFrequency;
    }

    public void setProfileUpdateFrequency(int profileUpdateFrequency) {
        this.profileUpdateFrequency = profileUpdateFrequency;
    }

    public int getGarbageCollectionWait() {
        return this.garbageCollectionWait;
    }

    public void setGarbageCollectionWait(int garbageCollectionWait) {
        this.garbageCollectionWait = garbageCollectionWait;
    }

    public boolean isGarbageCollectionOnShutdown() {
        return this.garbageCollectionOnShutdown;
    }

    public void setGarbageCollectionOnShutdown(boolean garbageCollectionOnShutdown) {
        this.garbageCollectionOnShutdown = garbageCollectionOnShutdown;
    }

    public void loadSettings(PropertiesWrapper p) {
        this.logDirectory = p.get("autofetch.logDirectory", this.logDirectory);
        this.queryTuning = p.getBoolean("autofetch.querytuning", this.queryTuning);
        this.queryTuningAddVersion = p.getBoolean("autofetch.queryTuningAddVersion", this.queryTuningAddVersion);
        this.garbageCollectionOnShutdown = p.getBoolean("autofetch.garbageCollectionOnShutdown", this.garbageCollectionOnShutdown);
        this.profiling = p.getBoolean("autofetch.profiling", this.profiling);
        this.mode = p.getEnum(AutofetchMode.class, "autofetch.implicitmode", this.mode);
        this.profilingMin = p.getInt("autofetch.profiling.min", this.profilingMin);
        this.profilingBase = p.getInt("autofetch.profiling.base", this.profilingBase);
        this.profilingRate = p.getDouble("autofetch.profiling.rate", this.profilingRate);
        this.profileUpdateFrequency = p.getInt("autofetch.profiling.updatefrequency", this.profileUpdateFrequency);
    }
}

