/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.PropertyMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertyMapLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertyMapLoader.class);

    PropertyMapLoader() {
    }

    public static PropertyMap loadGlobalProperties() {
        String fileName = System.getenv("EBEAN_PROPS_FILE");
        if (fileName == null && (fileName = System.getProperty("ebean.props.file")) == null) {
            fileName = "ebean.properties";
        }
        return PropertyMapLoader.load(null, fileName);
    }

    public static PropertyMap load(PropertyMap p, String fileName) {
        InputStream is = PropertyMapLoader.findInputStream(fileName);
        if (is == null) {
            logger.error(fileName + " not found");
            return p;
        }
        return PropertyMapLoader.load(p, is);
    }

    public static PropertyMap load(PropertyMap p, InputStream in) {
        Properties props = new Properties();
        try {
            props.load(in);
            in.close();
            return PropertyMapLoader.load(p, props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PropertyMap load(PropertyMap p, Properties props) {
        if (p == null) {
            p = new PropertyMap();
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase();
            String val = (String)entry.getValue();
            if (val != null) {
                val = val.trim();
            }
            p.put(key, val);
        }
        p.evaluateProperties();
        String otherProps = p.remove("load.properties");
        if (otherProps == null) {
            otherProps = p.remove("load.properties.override");
        }
        if (otherProps != null) {
            InputStream is = PropertyMapLoader.findInputStream(otherProps = otherProps.replace("\\", "/"));
            if (is != null) {
                logger.debug("loading properties from " + otherProps);
                PropertyMapLoader.load(p, is);
            } else {
                logger.error("load.properties " + otherProps + " not found.");
            }
        }
        return p;
    }

    private static InputStream findInputStream(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is null?");
        }
        try {
            File f = new File(fileName);
            if (f.exists()) {
                logger.debug(fileName + " found in file system");
                return new FileInputStream(f);
            }
            InputStream in = PropertyMapLoader.findInClassPath(fileName);
            if (in != null) {
                logger.debug(fileName + " found in classpath");
            }
            return in;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static InputStream findInClassPath(String fileName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
    }
}

