/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.config.TableName;

public class DbDdlSyntax {
    protected boolean renderIndexForFkey = true;
    protected boolean inlinePrimaryKeyConstraint = false;
    protected boolean addOneToOneUniqueContraint = true;
    protected int maxConstraintNameLength = 32;
    protected int columnNameWidth = 25;
    protected boolean dropKeyConstraints;
    protected String dropTableCascade;
    protected String dropIfExists;
    protected String newLine = "\n";
    protected String identity = "auto_increment";
    protected String identitySuffix = "";
    protected String pkPrefix = "pk_";
    protected String disableReferentialIntegrity;
    protected String enableReferentialIntegrity;
    protected String foreignKeySuffix;

    public String getPrimaryKeyName(String tableName) {
        String pk = this.pkPrefix + tableName;
        if (pk.length() > this.maxConstraintNameLength) {
            pk = pk.substring(0, this.maxConstraintNameLength);
        }
        return pk;
    }

    public String getIdentityColumnDefn(String columnDefn) {
        String identity = this.getIdentity();
        if (identity != null && identity.length() > 0) {
            return columnDefn + " " + identity;
        }
        return columnDefn;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getIdentitySuffix() {
        return this.identitySuffix;
    }

    public void setIdentitySuffix(String identitySuffix) {
        this.identitySuffix = identitySuffix;
    }

    public int getColumnNameWidth() {
        return this.columnNameWidth;
    }

    public void setColumnNameWidth(int columnNameWidth) {
        this.columnNameWidth = columnNameWidth;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    public String getPkPrefix() {
        return this.pkPrefix;
    }

    public void setPkPrefix(String pkPrefix) {
        this.pkPrefix = pkPrefix;
    }

    public String getDisableReferentialIntegrity() {
        return this.disableReferentialIntegrity;
    }

    public void setDisableReferentialIntegrity(String disableReferentialIntegrity) {
        this.disableReferentialIntegrity = disableReferentialIntegrity;
    }

    public String getEnableReferentialIntegrity() {
        return this.enableReferentialIntegrity;
    }

    public void setEnableReferentialIntegrity(String enableReferentialIntegrity) {
        this.enableReferentialIntegrity = enableReferentialIntegrity;
    }

    public boolean isDropKeyConstraints() {
        return this.dropKeyConstraints;
    }

    public String dropKeyConstraintPrefix(String tableName, String fkName) {
        return null;
    }

    public boolean isRenderIndexForFkey() {
        return this.renderIndexForFkey;
    }

    public void setRenderIndexForFkey(boolean renderIndexForFkey) {
        this.renderIndexForFkey = renderIndexForFkey;
    }

    public String getDropIfExists() {
        return this.dropIfExists;
    }

    public void setDropIfExists(String dropIfExists) {
        this.dropIfExists = dropIfExists;
    }

    public String dropTablePrefix(String tableName) {
        return "";
    }

    public String getDropTableCascade() {
        return this.dropTableCascade;
    }

    public void setDropTableCascade(String dropTableCascade) {
        this.dropTableCascade = dropTableCascade;
    }

    public String getForeignKeySuffix() {
        return this.foreignKeySuffix;
    }

    public void setForeignKeySuffix(String foreignKeySuffix) {
        this.foreignKeySuffix = foreignKeySuffix;
    }

    public int getMaxConstraintNameLength() {
        return this.maxConstraintNameLength;
    }

    public void setMaxConstraintNameLength(int maxFkeyLength) {
        this.maxConstraintNameLength = maxFkeyLength;
    }

    public boolean isAddOneToOneUniqueContraint() {
        return this.addOneToOneUniqueContraint;
    }

    public void setAddOneToOneUniqueContraint(boolean addOneToOneUniqueContraint) {
        this.addOneToOneUniqueContraint = addOneToOneUniqueContraint;
    }

    public boolean isInlinePrimaryKeyConstraint() {
        return this.inlinePrimaryKeyConstraint;
    }

    public void setInlinePrimaryKeyConstraint(boolean inlinePrimaryKeyConstraint) {
        this.inlinePrimaryKeyConstraint = inlinePrimaryKeyConstraint;
    }

    public String getIndexName(String table, String propName, int ixCount) {
        StringBuilder buffer = new StringBuilder(30);
        buffer.append("ix_").append(TableName.parse(table));
        buffer.append("_").append(propName);
        this.addSuffix(buffer, ixCount);
        return buffer.toString();
    }

    public String getForeignKeyName(String table, String propName, int fkCount) {
        StringBuilder buffer = new StringBuilder(30);
        buffer.append("fk_").append(TableName.parse(table));
        buffer.append("_").append(propName);
        this.addSuffix(buffer, fkCount);
        return buffer.toString();
    }

    protected void addSuffix(StringBuilder buffer, int count) {
        String suffixNr = Integer.toString(count);
        int suffixLen = suffixNr.length() + 1;
        if (buffer.length() + suffixLen > this.maxConstraintNameLength) {
            buffer.setLength(this.maxConstraintNameLength - suffixLen);
        }
        buffer.append("_");
        buffer.append(suffixNr);
    }
}

