/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import com.avaje.ebeaninternal.api.HashQueryPlan;

public class HashQueryPlanBuilder {
    private int planHash = 31;
    private int bindCount;
    private String rawSql;

    public String toString() {
        return this.planHash + ":" + this.bindCount + (this.rawSql != null ? ":r" : "");
    }

    public HashQueryPlanBuilder add(Class<?> cls) {
        this.planHash = this.planHash * 31 + cls.getName().hashCode();
        return this;
    }

    public HashQueryPlanBuilder add(Object object) {
        this.planHash = this.planHash * 31 + (object == null ? 0 : object.hashCode());
        return this;
    }

    public HashQueryPlanBuilder add(int hashValue) {
        this.planHash = this.planHash * 31 + hashValue;
        return this;
    }

    public HashQueryPlanBuilder add(boolean booleanValue) {
        this.planHash = this.planHash * 31 + (booleanValue ? 31 : 0);
        return this;
    }

    public HashQueryPlanBuilder bind(int extraBindCount) {
        this.bindCount += extraBindCount;
        return this;
    }

    public HashQueryPlanBuilder addRawSql(String rawSql) {
        this.rawSql = rawSql;
        return this;
    }

    public HashQueryPlan build() {
        return new HashQueryPlan(this.rawSql, this.planHash, this.bindCount);
    }
}

