/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autofetch;

import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.autofetch.DefaultAutoFetchManager;
import com.avaje.ebeaninternal.server.autofetch.TunedQueryInfo;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutoFetchManagerLogging {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAutoFetchManagerLogging.class);
    private final DefaultAutoFetchManager manager;
    private final int updateFreqInSecs;

    public DefaultAutoFetchManagerLogging(ServerConfig serverConfig, DefaultAutoFetchManager profileListener) {
        this.manager = profileListener;
        this.updateFreqInSecs = serverConfig.getAutofetchConfig().getProfileUpdateFrequency();
    }

    public void init(SpiEbeanServer ebeanServer) {
        ebeanServer.getBackgroundExecutor().executePeriodically(new UpdateProfile(), this.updateFreqInSecs, TimeUnit.SECONDS);
    }

    public void logInfo(String msg, Throwable e) {
        logger.info(msg, e);
    }

    public void logError(String msg, Throwable e) {
        logger.error(msg, e);
    }

    public void logSummary(String summaryInfo) {
        String msg = "\"Summary\",\"" + summaryInfo + "\",,,,";
        logger.debug(msg);
    }

    public void logChanged(TunedQueryInfo tunedFetch, OrmQueryDetail newQueryDetail) {
        String msg = tunedFetch.getLogOutput(newQueryDetail);
        logger.debug(msg);
    }

    public void logNew(TunedQueryInfo tunedFetch) {
        String msg = tunedFetch.getLogOutput(null);
        logger.debug(msg);
    }

    private final class UpdateProfile
    implements Runnable {
        private UpdateProfile() {
        }

        @Override
        public void run() {
            DefaultAutoFetchManagerLogging.this.manager.updateTunedQueryInfo();
        }
    }
}

