/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import java.sql.Connection;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanRequest {
    private static final Logger log = LoggerFactory.getLogger(BeanRequest.class);
    protected final SpiEbeanServer ebeanServer;
    protected final String serverName;
    protected SpiTransaction transaction;
    protected boolean createdTransaction;

    public BeanRequest(SpiEbeanServer ebeanServer, SpiTransaction t) {
        this.ebeanServer = ebeanServer;
        this.serverName = ebeanServer.getName();
        this.transaction = t;
    }

    public abstract void initTransIfRequired();

    public void createImplicitTransIfRequired(boolean readOnlyTransaction) {
        if (this.transaction == null) {
            this.transaction = this.ebeanServer.getCurrentServerTransaction();
            if (this.transaction == null || !this.transaction.isActive()) {
                this.transaction = this.ebeanServer.createServerTransaction(false, -1);
                this.createdTransaction = true;
            }
        }
    }

    public void commitTransIfRequired() {
        if (this.createdTransaction) {
            this.transaction.commit();
        }
    }

    public void rollbackTransIfRequired() {
        if (this.createdTransaction) {
            try {
                this.transaction.rollback();
            }
            catch (PersistenceException e) {
                log.error("Error trying to rollack a transaction (after a prior exception thrown)", (Throwable)e);
            }
        }
    }

    public EbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    public SpiEbeanServer getServer() {
        return this.ebeanServer;
    }

    public SpiTransaction getTransaction() {
        return this.transaction;
    }

    public Connection getConnection() {
        return this.transaction.getInternalConnection();
    }

    public boolean isLogSql() {
        return this.transaction.isLogSql();
    }

    public boolean isLogSummary() {
        return this.transaction.isLogSummary();
    }
}

