/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.meta.MetaObjectGraphNodeStats;
import com.avaje.ebeaninternal.server.util.LongAdder;
import java.util.concurrent.atomic.AtomicLong;

public class CObjectGraphNodeStatistics {
    private final ObjectGraphNode node;
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final LongAdder totalBeans = new LongAdder();
    private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());

    public CObjectGraphNodeStatistics(ObjectGraphNode node) {
        this.node = node;
    }

    public void add(long beanCount, long exeMicros) {
        this.count.increment();
        this.totalTime.add(exeMicros);
        this.totalBeans.add(beanCount);
    }

    public MetaObjectGraphNodeStats get(boolean reset) {
        if (reset) {
            return new Snapshot(this.node, this.startTime.getAndSet(System.currentTimeMillis()), this.count.sumThenReset(), this.totalTime.sumThenReset(), this.totalBeans.sumThenReset());
        }
        return new Snapshot(this.node, this.startTime.get(), this.count.sum(), this.totalTime.sum(), this.totalBeans.sum());
    }

    private static class Snapshot
    implements MetaObjectGraphNodeStats {
        private final ObjectGraphNode node;
        private final long startTime;
        private final long count;
        private final long totalTime;
        private final long totalBeans;

        public Snapshot(ObjectGraphNode node, long startTime, long count, long totalTime, long totalBeans) {
            this.node = node;
            this.startTime = startTime;
            this.count = count;
            this.totalTime = totalTime;
            this.totalBeans = totalBeans;
        }

        public String toString() {
            return this.node + " count[" + this.count + "] time[" + this.totalTime + "] beans[" + this.totalBeans + "]";
        }

        @Override
        public ObjectGraphNode getNode() {
            return this.node;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getTotalTime() {
            return this.totalTime;
        }

        @Override
        public long getTotalBeans() {
            return this.totalBeans;
        }
    }
}

