/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.common.BootupEbeanManager;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.PropertyMap;
import com.avaje.ebean.config.PstmtDelegate;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.UnderscoreNamingConvention;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.cache.DefaultServerCacheFactory;
import com.avaje.ebeaninternal.server.cache.DefaultServerCacheManager;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.BootupClassPathSearch;
import com.avaje.ebeaninternal.server.core.BootupClasses;
import com.avaje.ebeaninternal.server.core.DatabasePlatformFactory;
import com.avaje.ebeaninternal.server.core.DefaultBackgroundExecutor;
import com.avaje.ebeaninternal.server.core.DefaultServer;
import com.avaje.ebeaninternal.server.core.InternalConfiguration;
import com.avaje.ebeaninternal.server.core.JndiDataSourceLookup;
import com.avaje.ebeaninternal.server.core.XmlConfig;
import com.avaje.ebeaninternal.server.core.XmlConfigLoader;
import com.avaje.ebeaninternal.server.jdbc.OraclePstmtBatch;
import com.avaje.ebeaninternal.server.jdbc.StandardPstmtDelegate;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import com.avaje.ebeaninternal.server.lib.sql.DataSourcePool;
import com.avaje.ebeaninternal.server.lib.sql.SimpleDataSourceAlert;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerFactory
implements BootupEbeanManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServerFactory.class);
    private final ClusterManager clusterManager;
    private final JndiDataSourceLookup jndiDataSourceFactory;
    private final AtomicInteger serverId = new AtomicInteger(1);

    public DefaultServerFactory(ContainerConfig containerConfig) {
        this.clusterManager = new ClusterManager(containerConfig);
        this.jndiDataSourceFactory = new JndiDataSourceLookup();
        ShutdownManager.registerServerFactory(this);
    }

    @Override
    public void shutdown() {
        this.clusterManager.shutdown();
    }

    @Override
    public SpiEbeanServer createServer(String name) {
        ServerConfig config = new ServerConfig();
        config.setName(name);
        Properties prop = PropertyMap.defaultProperties();
        config.loadFromProperties(prop);
        return this.createServer(config);
    }

    private SpiBackgroundExecutor createBackgroundExecutor(ServerConfig serverConfig) {
        String namePrefix = "ebean-" + serverConfig.getName();
        int schedulePoolSize = serverConfig.getBackgroundExecutorSchedulePoolSize();
        int corePoolSize = serverConfig.getBackgroundExecutorCorePoolSize();
        int maxPoolSize = serverConfig.getBackgroundExecutorMaxPoolSize();
        int idleSecs = serverConfig.getBackgroundExecutorIdleSecs();
        int shutdownSecs = serverConfig.getBackgroundExecutorShutdownSecs();
        return new DefaultBackgroundExecutor(schedulePoolSize, corePoolSize, maxPoolSize, idleSecs, shutdownSecs, namePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpiEbeanServer createServer(ServerConfig serverConfig) {
        DefaultServerFactory defaultServerFactory = this;
        synchronized (defaultServerFactory) {
            this.setNamingConvention(serverConfig);
            BootupClasses bootupClasses = this.getBootupClasses(serverConfig);
            this.setDataSource(serverConfig);
            boolean online = this.checkDataSource(serverConfig);
            this.setDatabasePlatform(serverConfig);
            if (serverConfig.getDbEncrypt() != null) {
                serverConfig.getDatabasePlatform().setDbEncrypt(serverConfig.getDbEncrypt());
            }
            DatabasePlatform dbPlatform = serverConfig.getDatabasePlatform();
            OraclePstmtBatch pstmtBatch = null;
            if (dbPlatform.getName().startsWith("oracle")) {
                PstmtDelegate pstmtDelegate = serverConfig.getPstmtDelegate();
                if (pstmtDelegate == null) {
                    pstmtDelegate = this.getOraclePstmtDelegate(serverConfig.getDataSource());
                }
                if (pstmtDelegate != null) {
                    pstmtBatch = new OraclePstmtBatch(pstmtDelegate);
                }
                if (pstmtBatch == null) {
                    logger.warn("Can not support JDBC batching with Oracle without a PstmtDelegate");
                    serverConfig.setPersistBatching(false);
                }
            }
            serverConfig.getNamingConvention().setDatabasePlatform(serverConfig.getDatabasePlatform());
            ServerCacheManager cacheManager = this.getCacheManager(serverConfig);
            int uniqueServerId = this.serverId.incrementAndGet();
            SpiBackgroundExecutor bgExecutor = this.createBackgroundExecutor(serverConfig);
            XmlConfigLoader xmlConfigLoader = new XmlConfigLoader(null);
            XmlConfig xmlConfig = xmlConfigLoader.load();
            InternalConfiguration c = new InternalConfiguration(xmlConfig, this.clusterManager, cacheManager, bgExecutor, serverConfig, bootupClasses, pstmtBatch);
            DefaultServer server = new DefaultServer(c, cacheManager);
            cacheManager.init(server);
            if (serverConfig.isRegisterJmxMBeans()) {
                ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
                MBeanServer mbeanServer = list.size() == 0 ? MBeanServerFactory.createMBeanServer() : list.get(0);
                server.registerMBeans(mbeanServer, uniqueServerId);
            }
            server.executePlugins(online);
            server.initialise();
            if (online) {
                long sleepMillis;
                if (this.clusterManager.isClustering()) {
                    this.clusterManager.registerServer(server);
                }
                if ((sleepMillis = (long)(1000 * serverConfig.getCacheWarmingDelay())) > 0L) {
                    Timer timer = new Timer("EbeanCacheWarmer", true);
                    timer.schedule((TimerTask)new CacheWarmer(server, timer), sleepMillis);
                }
            }
            server.start();
            return server;
        }
    }

    private PstmtDelegate getOraclePstmtDelegate(DataSource ds) {
        if (ds instanceof DataSourcePool) {
            return new StandardPstmtDelegate();
        }
        return null;
    }

    private ServerCacheManager getCacheManager(ServerConfig serverConfig) {
        ServerCacheManager serverCacheManager = serverConfig.getServerCacheManager();
        if (serverCacheManager != null) {
            return serverCacheManager;
        }
        ServerCacheOptions beanOptions = new ServerCacheOptions();
        beanOptions.setMaxSize(serverConfig.getCacheMaxSize());
        beanOptions.setMaxIdleSecs(serverConfig.getCacheMaxIdleTime());
        beanOptions.setMaxSecsToLive(serverConfig.getCacheMaxTimeToLive());
        ServerCacheOptions queryOptions = new ServerCacheOptions();
        queryOptions.setMaxSize(serverConfig.getQueryCacheMaxSize());
        queryOptions.setMaxIdleSecs(serverConfig.getQueryCacheMaxIdleTime());
        queryOptions.setMaxSecsToLive(serverConfig.getQueryCacheMaxTimeToLive());
        ServerCacheFactory cacheFactory = serverConfig.getServerCacheFactory();
        if (cacheFactory == null) {
            cacheFactory = new DefaultServerCacheFactory();
        }
        return new DefaultServerCacheManager(cacheFactory, beanOptions, queryOptions);
    }

    private BootupClasses getBootupClasses(ServerConfig serverConfig) {
        BootupClasses bootupClasses = this.getBootupClasses1(serverConfig);
        bootupClasses.addPersistControllers(serverConfig.getPersistControllers());
        bootupClasses.addTransactionEventListeners(serverConfig.getTransactionEventListeners());
        bootupClasses.addPersistListeners(serverConfig.getPersistListeners());
        bootupClasses.addQueryAdapters(serverConfig.getQueryAdapters());
        bootupClasses.addServerConfigStartup(serverConfig.getServerConfigStartupListeners());
        bootupClasses.runServerConfigStartup(serverConfig);
        return bootupClasses;
    }

    private BootupClasses getBootupClasses1(ServerConfig serverConfig) {
        List<Class<?>> entityClasses = serverConfig.getClasses();
        if (entityClasses != null && entityClasses.size() > 0) {
            return new BootupClasses(serverConfig.getClasses());
        }
        BootupClassPathSearch search = new BootupClassPathSearch(null, serverConfig.getPackages(), serverConfig.getJars(), serverConfig.getClassPathReaderClassName());
        return search.getBootupClasses();
    }

    private void setNamingConvention(ServerConfig config) {
        if (config.getNamingConvention() == null) {
            UnderscoreNamingConvention nc = new UnderscoreNamingConvention();
            config.setNamingConvention(nc);
        }
    }

    private void setDatabasePlatform(ServerConfig config) {
        DatabasePlatform dbPlatform = config.getDatabasePlatform();
        if (dbPlatform == null) {
            DatabasePlatformFactory factory = new DatabasePlatformFactory();
            DatabasePlatform db = factory.create(config);
            config.setDatabasePlatform(db);
            logger.info("DatabasePlatform name:" + config.getName() + " platform:" + db.getName());
        }
    }

    private void setDataSource(ServerConfig config) {
        if (config.getDataSource() == null) {
            DataSource ds = this.getDataSourceFromConfig(config);
            config.setDataSource(ds);
        }
    }

    private DataSource getDataSourceFromConfig(ServerConfig config) {
        if (config.getDataSourceJndiName() != null) {
            DataSource ds = this.jndiDataSourceFactory.lookup(config.getDataSourceJndiName());
            if (ds == null) {
                String m = "JNDI lookup for DataSource " + config.getDataSourceJndiName() + " returned null.";
                throw new PersistenceException(m);
            }
            return ds;
        }
        DataSourceConfig dsConfig = config.getDataSourceConfig();
        if (dsConfig == null) {
            String m = "No DataSourceConfig definded for " + config.getName();
            throw new PersistenceException(m);
        }
        if (dsConfig.isOffline()) {
            if (config.getDatabasePlatformName() == null) {
                String m = "You MUST specify a DatabasePlatformName on ServerConfig when offline";
                throw new PersistenceException(m);
            }
            return null;
        }
        SimpleDataSourceAlert notify = new SimpleDataSourceAlert();
        return new DataSourcePool(notify, config.getName(), dsConfig);
    }

    private boolean checkDataSource(ServerConfig serverConfig) {
        if (serverConfig.getDataSource() == null) {
            if (serverConfig.getDataSourceConfig().isOffline()) {
                return false;
            }
            throw new RuntimeException("DataSource not set?");
        }
        Connection c = null;
        try {
            c = serverConfig.getDataSource().getConnection();
            if (c.getAutoCommit()) {
                String m = "DataSource [" + serverConfig.getName() + "] has autoCommit defaulting to true!";
                logger.warn(m);
            }
            boolean m = true;
            return m;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException ex) {
                    logger.error(null, (Throwable)ex);
                }
            }
        }
    }

    private static class CacheWarmer
    extends TimerTask {
        private final EbeanServer server;
        private final Timer timer;

        CacheWarmer(EbeanServer server, Timer timer) {
            this.server = server;
            this.timer = timer;
        }

        @Override
        public void run() {
            this.server.runCacheWarming();
            this.timer.cancel();
        }
    }
}

