/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.ValuePair;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.util.ValueUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiffHelp {
    public Map<String, ValuePair> diff(Object a, Object b, BeanDescriptor<?> desc) {
        if (!(a instanceof EntityBean)) {
            throw new IllegalArgumentException("First bean expected to be an enhanced EntityBean? bean:" + a);
        }
        if (b != null) {
            if (!(b instanceof EntityBean)) {
                throw new IllegalArgumentException("Second bean expected to be an enhanced EntityBean? bean:" + b);
            }
            if (!a.getClass().isAssignableFrom(b.getClass())) {
                throw new IllegalArgumentException("Second bean not assignable to the first bean?");
            }
        }
        if (b == null) {
            return ((EntityBean)a)._ebean_getIntercept().getDirtyValues();
        }
        LinkedHashMap<String, ValuePair> map = new LinkedHashMap<String, ValuePair>();
        this.diff(null, map, (EntityBean)a, (EntityBean)b, desc);
        return map;
    }

    public void diff(String prefix, Map<String, ValuePair> map, EntityBean first, EntityBean sec, BeanDescriptor<?> desc) {
        BeanProperty[] base = desc.propertiesBaseScalar();
        for (int i = 0; i < base.length; ++i) {
            Object bval;
            Object aval = base[i].getValue(first);
            if (ValueUtil.areEqual(aval, bval = base[i].getValue(sec))) continue;
            String propName = prefix == null ? base[i].getName() : prefix + base[i].getName();
            map.put(propName, new ValuePair(aval, bval));
        }
        this.diffAssocOne(prefix, first, sec, desc, map);
        this.diffEmbedded(prefix, first, sec, desc, map);
    }

    private void diffEmbedded(String prefix, EntityBean a, EntityBean b, BeanDescriptor<?> desc, Map<String, ValuePair> map) {
        BeanPropertyAssocOne<?>[] emb = desc.propertiesEmbedded();
        for (int i = 0; i < emb.length; ++i) {
            String propName;
            EntityBean bval;
            EntityBean aval = (EntityBean)emb[i].getValue(a);
            if (this.isBothNull(aval, bval = (EntityBean)emb[i].getValue(b))) continue;
            String string = propName = prefix == null ? emb[i].getName() : prefix + emb[i].getName();
            if (this.isDiffNull(aval, bval)) {
                map.put(propName, new ValuePair(aval, bval));
                continue;
            }
            BeanDescriptor embDesc = emb[i].getTargetDescriptor();
            this.diff(emb[i].getName() + ".", map, aval, bval, embDesc);
        }
    }

    private void diffAssocOne(String prefix, EntityBean a, EntityBean b, BeanDescriptor<?> desc, Map<String, ValuePair> map) {
        BeanPropertyAssocOne<?>[] ones = desc.propertiesOne();
        for (int i = 0; i < ones.length; ++i) {
            Object bOneId;
            String propName;
            Object bval;
            Object aval = ones[i].getValue(a);
            if (this.isBothNull(aval, bval = ones[i].getValue(b))) continue;
            String string = propName = prefix == null ? ones[i].getName() : prefix + ones[i].getName();
            if (this.isDiffNull(aval, bval)) {
                map.put(propName, new ValuePair(aval, bval));
                continue;
            }
            BeanDescriptor oneDesc = ones[i].getTargetDescriptor();
            Object aOneId = oneDesc.getId((EntityBean)aval);
            if (ValueUtil.areEqual(aOneId, bOneId = oneDesc.getId((EntityBean)bval))) continue;
            map.put(propName, new ValuePair(aval, bval));
        }
    }

    private boolean isBothNull(Object aval, Object bval) {
        return aval == null && bval == null;
    }

    private boolean isDiffNull(Object aval, Object bval) {
        if (aval == null) {
            return bval != null;
        }
        return bval == null;
    }
}

