/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.ValuePair;
import com.avaje.ebean.annotation.ConcurrencyMode;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanPersistRequest;
import com.avaje.ebeaninternal.api.DerivedRelationshipData;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanManager;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import com.avaje.ebeaninternal.server.persist.PersistExecute;
import com.avaje.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import com.avaje.ebeaninternal.server.transaction.BeanDelta;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIdMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.OptimisticLockException;

public final class PersistRequestBean<T>
extends PersistRequest
implements BeanPersistRequest<T> {
    private final BeanManager<T> beanManager;
    private final BeanDescriptor<T> beanDescriptor;
    private final BeanPersistListener beanPersistListener;
    private final BeanPersistController controller;
    private final T bean;
    private final EntityBean entityBean;
    private final EntityBeanIntercept intercept;
    private final Object parentBean;
    private final boolean dirty;
    private ConcurrencyMode concurrencyMode;
    private Object idValue;
    private Integer beanHash;
    private boolean statelessUpdate;
    private boolean notifyCache;
    private boolean deleteMissingChildren;
    private boolean updatedManysOnly;
    private List<BeanPropertyAssocMany<?>> updatedManys;
    private Set<String> updatedProperties;
    private boolean batched;
    private boolean skipBatchForTopLevel;
    private boolean batchOnCascadeSet;

    public PersistRequestBean(SpiEbeanServer server, T bean, Object parentBean, BeanManager<T> mgr, SpiTransaction t, PersistExecute persistExecute, PersistRequest.Type type, boolean saveRecurse) {
        super(server, t, persistExecute);
        this.entityBean = (EntityBean)bean;
        this.intercept = this.entityBean._ebean_getIntercept();
        this.beanManager = mgr;
        this.beanDescriptor = mgr.getBeanDescriptor();
        this.beanPersistListener = this.beanDescriptor.getPersistListener();
        this.bean = bean;
        this.parentBean = parentBean;
        this.controller = this.beanDescriptor.getPersistController();
        this.type = type;
        if (saveRecurse) {
            this.persistCascade = t.isPersistCascade();
        }
        if (this.type == PersistRequest.Type.UPDATE) {
            if (this.intercept.isNew()) {
                this.intercept.setNewBeanForUpdate();
                this.statelessUpdate = true;
            }
            this.beanDescriptor.checkMutableProperties(this.intercept);
        }
        this.concurrencyMode = this.beanDescriptor.getConcurrencyMode(this.intercept);
        this.dirty = this.intercept.isDirty();
    }

    public void initTransIfRequiredWithBatchCascade() {
        this.createImplicitTransIfRequired(false);
        if (this.transaction.checkBatchEscalationOnCascade(this)) {
            this.batchOnCascadeSet = !this.createdTransaction;
        }
        this.persistCascade = this.transaction.isPersistCascade();
    }

    public void flushBatchOnCascade() {
        if (this.batchOnCascadeSet) {
            this.transaction.flushBatchOnCascade();
            this.batchOnCascadeSet = false;
        }
    }

    public boolean isBatched() {
        return this.batched;
    }

    public void setBatched() {
        this.batched = true;
    }

    public void setSkipBatchForTopLevel() {
        this.skipBatchForTopLevel = true;
    }

    @Override
    public boolean isBatchThisRequest() {
        return !this.skipBatchForTopLevel && super.isBatchThisRequest();
    }

    public boolean isInsert() {
        return PersistRequest.Type.INSERT == this.type;
    }

    @Override
    public Set<String> getLoadedProperties() {
        return this.intercept.getLoadedPropertyNames();
    }

    @Override
    public Set<String> getUpdatedProperties() {
        return this.intercept.getDirtyPropertyNames();
    }

    @Override
    public Map<String, ValuePair> getUpdatedValues() {
        return this.intercept.getDirtyValues();
    }

    public boolean isNotify() {
        this.notifyCache = this.beanDescriptor.isCacheNotify();
        return this.notifyCache || this.isNotifyPersistListener();
    }

    public boolean isNotifyPersistListener() {
        return this.beanPersistListener != null;
    }

    public void notifyCache() {
        if (this.notifyCache) {
            switch (this.type) {
                case INSERT: {
                    this.beanDescriptor.cacheHandleInsert(this.idValue, this);
                    break;
                }
                case UPDATE: {
                    this.beanDescriptor.cacheHandleUpdate(this.idValue, this);
                    break;
                }
                case DELETE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type " + (Object)((Object)this.type));
                }
            }
        }
    }

    public void addToPersistMap(BeanPersistIdMap beanPersistMap) {
        beanPersistMap.add(this.beanDescriptor, this.type, this.idValue);
    }

    public boolean notifyLocalPersistListener() {
        if (this.beanPersistListener == null) {
            return false;
        }
        switch (this.type) {
            case INSERT: {
                return this.beanPersistListener.inserted(this.bean);
            }
            case UPDATE: {
                return this.beanPersistListener.updated(this.bean, this.updatedProperties);
            }
            case DELETE: {
                return this.beanPersistListener.deleted(this.bean);
            }
        }
        return false;
    }

    public boolean isParent(Object o) {
        return o == this.parentBean;
    }

    public boolean isRegisteredBean() {
        return this.transaction.isRegisteredBean(this.bean);
    }

    public void unRegisterBean() {
        this.transaction.unregisterBean(this.bean);
    }

    private Integer getBeanHash() {
        if (this.beanHash == null) {
            Object id = this.beanDescriptor.getId(this.entityBean);
            int hc = 31 * this.bean.getClass().getName().hashCode();
            if (id != null) {
                hc += id.hashCode();
            }
            this.beanHash = new Integer(hc);
        }
        return this.beanHash;
    }

    public void registerDeleteBean() {
        Integer hash = this.getBeanHash();
        this.transaction.registerDeleteBean(hash);
    }

    public void unregisterDeleteBean() {
        Integer hash = this.getBeanHash();
        this.transaction.unregisterDeleteBean(hash);
    }

    public boolean isRegisteredForDeleteBean() {
        if (this.transaction == null) {
            return false;
        }
        Integer hash = this.getBeanHash();
        return this.transaction.isRegisteredDeleteBean(hash);
    }

    public BeanManager<T> getBeanManager() {
        return this.beanManager;
    }

    public BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public boolean isDeleteMissingChildren() {
        return this.deleteMissingChildren;
    }

    public void setDeleteMissingChildren(boolean deleteMissingChildren) {
        this.deleteMissingChildren = deleteMissingChildren;
    }

    public void postControllerPrepareUpdate() {
        if (this.intercept.isNew() && this.controller != null) {
            this.intercept.setNewBeanForUpdate();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public ConcurrencyMode getConcurrencyMode() {
        return this.concurrencyMode;
    }

    public String getFullName() {
        return this.beanDescriptor.getFullName();
    }

    @Override
    public T getBean() {
        return this.bean;
    }

    public EntityBean getEntityBean() {
        return this.entityBean;
    }

    public Object getBeanId() {
        return this.beanDescriptor.getId(this.entityBean);
    }

    public BeanDelta createDeltaBean() {
        return new BeanDelta(this.beanDescriptor, this.getBeanId());
    }

    public Object getParentBean() {
        return this.parentBean;
    }

    public BeanPersistController getBeanController() {
        return this.controller;
    }

    public EntityBeanIntercept getEntityBeanIntercept() {
        return this.intercept;
    }

    public boolean isLoadedProperty(BeanProperty prop) {
        return this.intercept.isLoadedProperty(prop.getPropertyIndex());
    }

    @Override
    public int executeNow() {
        switch (this.type) {
            case INSERT: {
                this.persistExecute.executeInsertBean(this);
                return -1;
            }
            case UPDATE: {
                if (this.beanPersistListener != null) {
                    this.updatedProperties = this.getUpdatedProperties();
                }
                this.persistExecute.executeUpdateBean(this);
                return -1;
            }
            case DELETE: {
                this.persistExecute.executeDeleteBean(this);
                return -1;
            }
        }
        throw new RuntimeException("Invalid type " + (Object)((Object)this.type));
    }

    @Override
    public int executeOrQueue() {
        boolean batch = this.isBatchThisRequest();
        BatchControl control = this.transaction.getBatchControl();
        if (control != null) {
            return control.executeOrQueue(this, batch);
        }
        if (batch) {
            control = this.persistExecute.createBatchControl(this.transaction);
            return control.executeOrQueue(this, true);
        }
        return this.executeNow();
    }

    @Override
    public void setGeneratedKey(Object idValue) {
        if (idValue != null) {
            this.idValue = this.beanDescriptor.convertSetId(idValue, this.entityBean);
        }
    }

    public void setBoundId(Object idValue) {
        this.idValue = idValue;
    }

    @Override
    public final void checkRowCount(int rowCount) throws SQLException {
        if (rowCount != 1) {
            String m = Message.msg("persist.conc2", "" + rowCount);
            throw new OptimisticLockException(m, null, this.bean);
        }
        switch (this.type) {
            case DELETE: {
                this.postDelete();
                break;
            }
            case UPDATE: {
                this.postUpdate();
                break;
            }
        }
    }

    private void postUpdate() {
        if (this.statelessUpdate) {
            this.transaction.getPersistenceContext().clear(this.beanDescriptor.getBeanType(), this.idValue);
        }
    }

    private void postDelete() {
        this.transaction.getPersistenceContext().clear(this.beanDescriptor.getBeanType(), this.idValue);
        this.beanDescriptor.cacheHandleDelete(this.idValue, this);
    }

    @Override
    public void postExecute() throws SQLException {
        if (this.controller != null) {
            this.controllerPost();
        }
        this.intercept.setLoaded();
        this.addEvent();
        if (this.isLogSummary()) {
            this.logSummary();
        }
    }

    private void controllerPost() {
        switch (this.type) {
            case INSERT: {
                this.controller.postInsert(this);
                break;
            }
            case UPDATE: {
                this.controller.postUpdate(this);
                break;
            }
            case DELETE: {
                this.controller.postDelete(this);
                break;
            }
        }
    }

    private void logSummary() {
        String name = this.beanDescriptor.getName();
        switch (this.type) {
            case INSERT: {
                this.transaction.logSummary("Inserted [" + name + "] [" + this.idValue + "]");
                break;
            }
            case UPDATE: {
                this.transaction.logSummary("Updated [" + name + "] [" + this.idValue + "]");
                break;
            }
            case DELETE: {
                this.transaction.logSummary("Deleted [" + name + "] [" + this.idValue + "]");
                break;
            }
        }
    }

    private void addEvent() {
        TransactionEvent event = this.transaction.getEvent();
        if (event != null) {
            event.add(this);
        }
    }

    public ConcurrencyMode determineConcurrencyMode() {
        BeanProperty prop;
        if (this.concurrencyMode.equals((Object)ConcurrencyMode.VERSION) && ((prop = this.beanDescriptor.getVersionProperty()) == null || !this.intercept.isLoadedProperty(prop.getPropertyIndex()))) {
            this.concurrencyMode = ConcurrencyMode.NONE;
        }
        return this.concurrencyMode;
    }

    public boolean isDynamicUpdateSql() {
        return this.beanDescriptor.isUpdateChangesOnly() || !this.intercept.isFullyLoadedBean();
    }

    public GenerateDmlRequest createGenerateDmlRequest(boolean emptyStringAsNull) {
        return new GenerateDmlRequest(emptyStringAsNull, this.intercept, this.beanDescriptor.isUpdateChangesOnly());
    }

    public boolean isAddToUpdate(BeanProperty prop) {
        return this.intercept.isDirtyProperty(prop.getPropertyIndex());
    }

    public List<DerivedRelationshipData> getDerivedRelationships() {
        return this.transaction.getDerivedRelationship(this.bean);
    }

    public void postInsert() {
        int len = this.intercept.getPropertyLength();
        for (int i = 0; i < len; ++i) {
            this.intercept.setLoadedProperty(i);
        }
    }

    public boolean isReference() {
        return this.beanDescriptor.isReference(this.intercept);
    }

    public void addUpdatedManyProperty(BeanPropertyAssocMany<?> updatedAssocMany) {
        if (this.updatedManys == null) {
            this.updatedManys = new ArrayList(5);
        }
        this.updatedManys.add(updatedAssocMany);
    }

    public List<BeanPropertyAssocMany<?>> getUpdatedManyCollections() {
        return this.updatedManys;
    }

    public void checkUpdatedManysOnly() {
        if (!this.dirty && this.updatedManys != null) {
            if (this.idValue == null) {
                this.idValue = this.beanDescriptor.getId(this.entityBean);
            }
            this.updatedManysOnly = true;
            this.addEvent();
        }
    }

    public boolean isUpdatedManysOnly() {
        return this.updatedManysOnly;
    }
}

