/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ddl;

import com.avaje.ebean.config.dbplatform.DbDdlSyntax;
import com.avaje.ebeaninternal.server.ddl.AbstractBeanVisitor;
import com.avaje.ebeaninternal.server.ddl.BaseTablePropertyVisitor;
import com.avaje.ebeaninternal.server.ddl.DdlGenContext;
import com.avaje.ebeaninternal.server.ddl.PropertyVisitor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompound;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;

public class AddForeignKeysVisitor
extends AbstractBeanVisitor {
    final DdlGenContext ctx;
    final FkeyPropertyVisitor pv;

    public AddForeignKeysVisitor(boolean addMode, DdlGenContext ctx) {
        this.ctx = ctx;
        this.pv = new FkeyPropertyVisitor(addMode, this, ctx);
    }

    @Override
    public boolean visitBean(BeanDescriptor<?> descriptor) {
        return descriptor.isInheritanceRoot();
    }

    @Override
    public void visitBeanEnd(BeanDescriptor<?> descriptor) {
        this.visitInheritanceProperties(descriptor, this.pv);
    }

    @Override
    public void visitBegin() {
    }

    @Override
    public void visitEnd() {
        this.ctx.addIntersectionFkeys();
    }

    @Override
    public PropertyVisitor visitProperty(BeanProperty p) {
        return this.pv;
    }

    public static class FkeyPropertyVisitor
    extends BaseTablePropertyVisitor {
        final boolean addMode;
        final DdlGenContext ctx;
        final AddForeignKeysVisitor parent;

        public FkeyPropertyVisitor(boolean addMode, AddForeignKeysVisitor parent, DdlGenContext ctx) {
            this.addMode = addMode;
            this.parent = parent;
            this.ctx = ctx;
        }

        @Override
        public void visitEmbeddedScalar(BeanProperty p, BeanPropertyAssocOne<?> embedded) {
        }

        @Override
        public void visitOneImported(BeanPropertyAssocOne<?> p) {
            String dropKeyConstraintPrefix;
            String baseTable = p.getBeanDescriptor().getBaseTable();
            TableJoin tableJoin = p.getTableJoin();
            TableJoinColumn[] columns = tableJoin.columns();
            String tableName = p.getBeanDescriptor().getBaseTable();
            DbDdlSyntax ddlSyntax = this.ctx.getDdlSyntax();
            String fkName = ddlSyntax.getForeignKeyName(tableName, p.getName(), this.ctx.incrementFkCount());
            if (!this.addMode && (dropKeyConstraintPrefix = ddlSyntax.dropKeyConstraintPrefix(tableName, fkName)) != null && !dropKeyConstraintPrefix.isEmpty()) {
                this.ctx.write(dropKeyConstraintPrefix).write(" ");
            }
            this.ctx.write("alter table ").write(baseTable).write(this.addOrDrop());
            if (fkName != null) {
                this.ctx.write("constraint ").write(fkName).write(" ");
            }
            if (this.addMode) {
                int i;
                this.ctx.write("foreign key (");
                for (i = 0; i < columns.length; ++i) {
                    if (i > 0) {
                        this.ctx.write(",");
                    }
                    this.ctx.write(columns[i].getLocalDbColumn());
                }
                this.ctx.write(")");
                this.ctx.write(" references ");
                this.ctx.write(tableJoin.getTable());
                this.ctx.write(" (");
                for (i = 0; i < columns.length; ++i) {
                    if (i > 0) {
                        this.ctx.write(",");
                    }
                    this.ctx.write(columns[i].getForeignDbColumn());
                }
                this.ctx.write(")");
                String fkeySuffix = this.ctx.getDdlSyntax().getForeignKeySuffix();
                if (fkeySuffix != null) {
                    this.ctx.write(" ").write(fkeySuffix);
                }
            }
            this.ctx.write(";").writeNewLine();
            if (this.addMode && ddlSyntax.isRenderIndexForFkey()) {
                this.ctx.write("create index ");
                String idxName = ddlSyntax.getIndexName(tableName, p.getName(), this.ctx.incrementIxCount());
                if (idxName != null) {
                    this.ctx.write(idxName);
                }
                this.ctx.write(" on ").write(baseTable).write(" (");
                for (int i = 0; i < columns.length; ++i) {
                    if (i > 0) {
                        this.ctx.write(",");
                    }
                    this.ctx.write(columns[i].getLocalDbColumn());
                }
                this.ctx.write(");").writeNewLine();
            }
        }

        protected String addOrDrop() {
            return this.addMode ? " add " : " drop ";
        }

        @Override
        public void visitScalar(BeanProperty p) {
        }

        @Override
        public void visitCompound(BeanPropertyCompound p) {
        }

        @Override
        public void visitCompoundScalar(BeanPropertyCompound compound, BeanProperty p) {
        }
    }
}

