/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ddl;

import com.avaje.ebeaninternal.server.ddl.AbstractBeanVisitor;
import com.avaje.ebeaninternal.server.ddl.BaseTablePropertyVisitor;
import com.avaje.ebeaninternal.server.ddl.DdlGenContext;
import com.avaje.ebeaninternal.server.ddl.PropertyVisitor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompound;

public class CreateIndexVisitor
extends AbstractBeanVisitor {
    private final IndexPropertyVisitor iv;

    public CreateIndexVisitor(DdlGenContext ctx) {
        this.iv = new IndexPropertyVisitor(ctx);
    }

    @Override
    public void visitBegin() {
    }

    @Override
    public boolean visitBean(BeanDescriptor<?> descriptor) {
        return descriptor.isInheritanceRoot();
    }

    @Override
    public PropertyVisitor visitProperty(BeanProperty p) {
        return this.iv;
    }

    @Override
    public void visitBeanEnd(BeanDescriptor<?> descriptor) {
        this.visitInheritanceProperties(descriptor, this.iv);
    }

    @Override
    public void visitEnd() {
    }

    private static final class IndexPropertyVisitor
    extends BaseTablePropertyVisitor {
        private final DdlGenContext ctx;

        public IndexPropertyVisitor(DdlGenContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void visitEmbeddedScalar(BeanProperty p, BeanPropertyAssocOne<?> embedded) {
        }

        @Override
        public void visitOneImported(BeanPropertyAssocOne<?> p) {
        }

        @Override
        public void visitScalar(BeanProperty p) {
            String baseTable = p.getBeanDescriptor().getBaseTable();
            if (p.isIndexed()) {
                String indexName = p.getIndexName();
                if (indexName.length() == 0) {
                    indexName = this.ctx.getDdlSyntax().getIndexName(baseTable, p.getDbColumn(), this.ctx.incrementIxCount());
                }
                this.ctx.write("create index ").write(indexName).write(" on ").write(baseTable).write("(").write(p.getDbColumn()).write(");").writeNewLine();
            }
        }

        @Override
        public void visitCompoundScalar(BeanPropertyCompound compound, BeanProperty p) {
        }
    }
}

