/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Query;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cache.CachedBeanData;
import com.avaje.ebeaninternal.server.cache.CachedBeanDataFromBean;
import com.avaje.ebeaninternal.server.cache.CachedBeanDataToBean;
import com.avaje.ebeaninternal.server.cache.CachedBeanDataUpdate;
import com.avaje.ebeaninternal.server.cache.CachedManyIds;
import com.avaje.ebeaninternal.server.core.CacheOptions;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionUtil;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanDescriptorCacheHelp<T> {
    public static final Logger queryLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.QUERY");
    public static final Logger beanLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.BEAN");
    public static final Logger manyLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.COLL");
    public static final Logger natLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.NATKEY");
    private final BeanDescriptor<T> desc;
    private final ServerCacheManager cacheManager;
    private final CacheOptions cacheOptions;
    private final boolean cacheSharableBeans;
    private final Class<T> beanType;
    private final String cacheName;
    private final BeanPropertyAssocOne<?>[] propertiesOneImported;
    private ServerCache beanCache;
    private ServerCache naturalKeyCache;
    private ServerCache queryCache;

    public BeanDescriptorCacheHelp(BeanDescriptor<T> desc, ServerCacheManager cacheManager, CacheOptions cacheOptions, boolean cacheSharableBeans, BeanPropertyAssocOne<?>[] propertiesOneImported) {
        this.desc = desc;
        this.beanType = desc.getBeanType();
        this.cacheName = this.beanType.getSimpleName();
        this.cacheManager = cacheManager;
        this.cacheOptions = cacheOptions;
        this.cacheSharableBeans = cacheSharableBeans;
        this.propertiesOneImported = propertiesOneImported;
    }

    public void initialise() {
        if (this.cacheOptions.isUseNaturalKeyCache()) {
            this.naturalKeyCache = this.cacheManager.getNaturalKeyCache(this.beanType);
        }
        if (this.cacheOptions.isUseCache()) {
            this.beanCache = this.cacheManager.getBeanCache(this.beanType);
        }
    }

    public void runCacheWarming(EbeanServer ebeanServer) {
        if (this.cacheOptions == null) {
            return;
        }
        String warmingQuery = this.cacheOptions.getWarmingQuery();
        if (warmingQuery != null && warmingQuery.trim().length() > 0) {
            Query<T> query = ebeanServer.createQuery(this.beanType, warmingQuery);
            query.setUseCache(true);
            query.setReadOnly(true);
            query.setLoadBeanCache(true);
            List<T> list = query.findList();
            if (beanLog.isInfoEnabled()) {
                beanLog.info("Loaded {} cache with [{}] beans", (Object)this.cacheName, (Object)list.size());
            }
        }
    }

    public void setUseCache(boolean useCache) {
        if (useCache) {
            this.getBeanCache();
        } else {
            this.beanCacheClear();
            this.beanCache = null;
        }
    }

    public boolean isQueryCaching() {
        return this.queryCache != null;
    }

    public boolean isBeanCaching() {
        return this.beanCache != null;
    }

    public boolean isCacheNotify() {
        if (this.isBeanCaching() || this.isQueryCaching()) {
            return true;
        }
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            if (!this.propertiesOneImported[i].getTargetDescriptor().isBeanCaching()) continue;
            return true;
        }
        return false;
    }

    public CacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    public void queryCacheClear() {
        if (this.queryCache != null) {
            if (queryLog.isDebugEnabled()) {
                queryLog.debug("   CLEAR {}", (Object)this.cacheName);
            }
            this.queryCache.clear();
        }
    }

    public BeanCollection<T> queryCacheGet(Object id) {
        if (this.queryCache == null) {
            return null;
        }
        return (BeanCollection)this.queryCache.get(id);
    }

    public void queryCachePut(Object id, BeanCollection<T> query) {
        if (this.queryCache == null) {
            this.queryCache = this.cacheManager.getQueryCache(this.beanType);
        }
        if (queryLog.isDebugEnabled()) {
            queryLog.debug("   PUT {} {}", (Object)this.cacheName, id);
        }
        this.queryCache.put(id, query);
    }

    public void manyPropRemove(Object parentId, String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isDebugEnabled()) {
            manyLog.debug("   REMOVE {}({}).{}", new Object[]{this.cacheName, parentId, propertyName});
        }
        collectionIdsCache.remove(parentId);
    }

    public void manyPropClear(String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isDebugEnabled()) {
            manyLog.debug("   CLEAR {}(*).{} ", (Object)this.cacheName, (Object)propertyName);
        }
        collectionIdsCache.clear();
    }

    public CachedManyIds manyPropGet(Object parentId, String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        CachedManyIds entry = (CachedManyIds)collectionIdsCache.get(parentId);
        if (entry == null) {
            if (manyLog.isTraceEnabled()) {
                manyLog.trace("   GET {}({}).{} - cache miss", new Object[]{this.cacheName, parentId, propertyName});
            }
        } else if (manyLog.isDebugEnabled()) {
            manyLog.debug("   GET {}({}).{} - hit", new Object[]{this.cacheName, parentId, propertyName});
        }
        return entry;
    }

    public boolean manyPropLoad(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, Object parentId, Boolean readOnly) {
        CachedManyIds entry = this.manyPropGet(parentId, many.getName());
        if (entry == null) {
            return false;
        }
        EntityBean ownerBean = bc.getOwnerBean();
        EntityBeanIntercept ebi = ownerBean._ebean_getIntercept();
        PersistenceContext persistenceContext = ebi.getPersistenceContext();
        BeanDescriptor targetDescriptor = many.getTargetDescriptor();
        List<Object> idList = entry.getIdList();
        bc.checkEmptyLazyLoad();
        for (int i = 0; i < idList.size(); ++i) {
            Object id = idList.get(i);
            Object refBean = targetDescriptor.createReference(readOnly, id);
            EntityBeanIntercept refEbi = ((EntityBean)refBean)._ebean_getIntercept();
            many.add(bc, (EntityBean)refBean);
            persistenceContext.put(id, refBean);
            refEbi.setPersistenceContext(persistenceContext);
        }
        return true;
    }

    public void manyPropPut(BeanPropertyAssocMany<?> many, Object details, Object parentId) {
        BeanDescriptor targetDescriptor = many.getTargetDescriptor();
        ArrayList<Object> idList = new ArrayList<Object>();
        Collection<?> actualDetails = BeanCollectionUtil.getActualEntries(details);
        for (Object bean : actualDetails) {
            idList.add(targetDescriptor.getId((EntityBean)bean));
        }
        CachedManyIds entry = new CachedManyIds(idList);
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, many.getName());
        if (manyLog.isDebugEnabled()) {
            manyLog.debug("   PUT {}({}).{} - ids:{}", new Object[]{this.cacheName, parentId, many.getName(), entry});
        }
        collectionIdsCache.put(parentId, entry);
    }

    public T naturalKeyLookup(SpiQuery<T> query, SpiTransaction t) {
        if (!this.isNaturalKeyCaching(query.isUseBeanCache())) {
            return null;
        }
        NaturalKeyBindParam keyBindParam = query.getNaturalKeyBindParam();
        if (keyBindParam == null || !this.isNaturalKey(keyBindParam.getName())) {
            return null;
        }
        Object id = this.naturalKeyCache.get(keyBindParam.getValue());
        if (natLog.isTraceEnabled()) {
            natLog.trace(" LOOKUP {}({}) - id:{}", new Object[]{this.cacheName, keyBindParam.getValue(), id});
        }
        if (id == null) {
            return null;
        }
        T cacheBean = this.beanCacheGetInternal(id, query.isReadOnly());
        if (cacheBean != null) {
            this.setupContext(cacheBean, query, this.getPersistenceContext(t));
        }
        return cacheBean;
    }

    private PersistenceContext getPersistenceContext(SpiTransaction t) {
        PersistenceContext context = null;
        if (t == null) {
            t = this.desc.getEbeanServer().getCurrentServerTransaction();
        }
        if (t != null) {
            context = t.getPersistenceContext();
        }
        return context;
    }

    private boolean isNaturalKeyCaching(Boolean queryUseCache) {
        return this.naturalKeyCache != null && (queryUseCache == null || queryUseCache != false);
    }

    private boolean isNaturalKey(String propName) {
        return propName != null && propName.equals(this.cacheOptions.getNaturalKey());
    }

    private void setupContext(Object bean, SpiQuery<T> query, PersistenceContext context) {
        if (context == null) {
            context = new DefaultPersistenceContext();
        }
        EntityBean entityBean = (EntityBean)bean;
        EntityBeanIntercept ebi = entityBean._ebean_getIntercept();
        ebi.setPersistenceContext(context);
        Object id = this.desc.getId(entityBean);
        context.put(id, bean);
    }

    private ServerCache getBeanCache() {
        if (this.beanCache == null) {
            this.beanCache = this.cacheManager.getBeanCache(this.beanType);
        }
        return this.beanCache;
    }

    public void beanCacheClear() {
        if (this.beanCache != null) {
            if (beanLog.isDebugEnabled()) {
                beanLog.debug("   CLEAR {}", (Object)this.cacheName);
            }
            this.beanCache.clear();
        }
    }

    public CachedBeanData beanExtractData(EntityBean bean) {
        return CachedBeanDataFromBean.extract(this.desc, bean);
    }

    public void beanLoadData(EntityBean bean, CachedBeanData data) {
        CachedBeanDataToBean.load(this.desc, bean, data);
    }

    public void beanCachePut(EntityBean bean) {
        Object naturalKey;
        CachedBeanData beanData = this.beanExtractData(bean);
        Object id = this.desc.getId(bean);
        if (beanLog.isDebugEnabled()) {
            beanLog.debug("   PUT {}({})", (Object)this.cacheName, id);
        }
        this.getBeanCache().put(id, beanData);
        if (beanData.isNaturalKeyUpdate() && this.naturalKeyCache != null && (naturalKey = beanData.getNaturalKey()) != null) {
            if (natLog.isDebugEnabled()) {
                natLog.debug(" PUT {}({}, {})", new Object[]{this.cacheName, naturalKey, id});
            }
            this.naturalKeyCache.put(naturalKey, id);
        }
    }

    public CachedBeanData beanCacheGetData(Object id) {
        return (CachedBeanData)this.getBeanCache().get(id);
    }

    public T beanCacheGet(SpiQuery<T> query, PersistenceContext context) {
        T bean = this.beanCacheGetInternal(query.getId(), query.isReadOnly());
        if (bean != null) {
            this.setupContext(bean, query, context);
        }
        return bean;
    }

    private T beanCacheGetInternal(Object id, Boolean readOnly) {
        Object bean;
        CachedBeanData data = (CachedBeanData)this.getBeanCache().get(id);
        if (data == null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   GET {}({}) - cache miss", (Object)this.cacheName, id);
            }
            return null;
        }
        if (this.cacheSharableBeans && !Boolean.FALSE.equals(readOnly) && (bean = data.getSharableBean()) != null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   GET {}({}) - hit shared bean", (Object)this.cacheName, id);
            }
            return (T)bean;
        }
        bean = this.desc.createEntityBean();
        this.desc.convertSetId(id, (EntityBean)bean);
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        ebi.setBeanLoader(this.desc.getEbeanServer());
        if (Boolean.TRUE.equals(readOnly)) {
            ebi.setReadOnly(true);
        }
        this.beanLoadData((EntityBean)bean, data);
        if (beanLog.isTraceEnabled()) {
            beanLog.trace("   GET {}({}) - hit", (Object)this.cacheName, id);
        }
        return (T)bean;
    }

    public void beanCacheRemove(Object id) {
        if (this.beanCache != null) {
            if (beanLog.isDebugEnabled()) {
                beanLog.debug("   REMOVE {}({})", (Object)this.cacheName, id);
            }
            this.beanCache.remove(id);
        }
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            this.propertiesOneImported[i].cacheClear();
        }
    }

    public boolean beanCacheLoad(EntityBean bean, EntityBeanIntercept ebi, Object id) {
        CachedBeanData cacheData = (CachedBeanData)this.getBeanCache().get(id);
        if (cacheData == null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   LOAD {}({}) - cache miss", (Object)this.cacheName, id);
            }
            return false;
        }
        int lazyLoadProperty = ebi.getLazyLoadPropertyIndex();
        if (lazyLoadProperty > -1 && !cacheData.isLoaded(lazyLoadProperty)) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   LOAD {}({}) - cache miss on property", (Object)this.cacheName, id);
            }
            return false;
        }
        CachedBeanDataToBean.load(this.desc, bean, cacheData);
        if (beanLog.isDebugEnabled()) {
            beanLog.debug("   LOAD {}({}) - hit", (Object)this.cacheName, id);
        }
        return true;
    }

    public void handleDelete(Object id, PersistRequestBean<T> deleteRequest) {
        if (this.queryCache != null) {
            if (queryLog.isDebugEnabled()) {
                queryLog.debug("   CLEAR {}(*) - delete trigger", (Object)this.cacheName);
            }
            this.queryCache.clear();
        }
        if (this.beanCache != null) {
            if (beanLog.isDebugEnabled()) {
                beanLog.debug("   REMOVE {}({})", (Object)this.cacheName, id);
            }
            this.beanCache.remove(id);
        }
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            BeanPropertyAssocMany<?> many = this.propertiesOneImported[i].getRelationshipProperty();
            if (many == null) continue;
            this.propertiesOneImported[i].cacheDelete(true, deleteRequest.getEntityBean());
        }
    }

    public void handleInsert(Object id, PersistRequestBean<T> insertRequest) {
        if (this.queryCache != null) {
            if (queryLog.isDebugEnabled()) {
                queryLog.debug("   CLEAR {}(*) - insert trigger", (Object)this.cacheName);
            }
            this.queryCache.clear();
        }
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            this.propertiesOneImported[i].cacheDelete(false, insertRequest.getEntityBean());
        }
    }

    public void handleUpdate(Object id, PersistRequestBean<T> updateRequest) {
        ServerCache cache;
        CachedBeanData existingData;
        int i;
        List<BeanPropertyAssocMany<?>> manyCollections;
        if (this.queryCache != null) {
            if (queryLog.isDebugEnabled()) {
                queryLog.debug("   CLEAR {}(*) - update trigger", (Object)this.cacheName);
            }
            this.queryCache.clear();
        }
        if ((manyCollections = updateRequest.getUpdatedManyCollections()) != null) {
            for (i = 0; i < manyCollections.size(); ++i) {
                this.manyPropRemove(id, manyCollections.get(i).getName());
            }
        }
        if (!updateRequest.isUpdatedManysOnly() && (existingData = (CachedBeanData)(cache = this.getBeanCache()).get(id)) != null) {
            if (this.isCachedDataTooOld(existingData)) {
                if (beanLog.isDebugEnabled()) {
                    beanLog.debug("   REMOVE {}({}) - entry too old", (Object)this.cacheName, id);
                }
                cache.remove(id);
            } else {
                CachedBeanData newData = CachedBeanDataUpdate.update(this.desc, existingData, updateRequest.getEntityBean());
                if (beanLog.isDebugEnabled()) {
                    beanLog.debug("   UPDATE {}({})", (Object)this.cacheName, id);
                }
                cache.put(id, newData);
                if (newData.isNaturalKeyUpdate() && this.naturalKeyCache != null) {
                    Object oldKey = newData.getOldNaturalKey();
                    Object newKey = newData.getNaturalKey();
                    if (natLog.isDebugEnabled()) {
                        natLog.debug(".. update {} PUT({}, {}) REMOVE({})", new Object[]{this.cacheName, newKey, id, oldKey});
                    }
                    if (oldKey != null) {
                        this.naturalKeyCache.remove(oldKey);
                    }
                    if (newKey != null) {
                        this.naturalKeyCache.put(newKey, id);
                    }
                }
            }
        }
        if (manyCollections != null) {
            for (i = 0; i < manyCollections.size(); ++i) {
                BeanPropertyAssocMany<?> many = manyCollections.get(i);
                Object manyValue = many.getValue(updateRequest.getEntityBean());
                this.manyPropPut(many, manyValue, id);
            }
        }
    }

    private boolean isCachedDataTooOld(CachedBeanData existingData) {
        return this.cacheOptions.isTooOldInMillis(System.currentTimeMillis() - existingData.getWhenCreated());
    }

    public void handleBulkUpdate(TransactionEventTable.TableIUD tableIUD) {
        if (tableIUD.isUpdateOrDelete()) {
            this.beanCacheClear();
        }
        this.queryCacheClear();
    }
}

