/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public class BeanDescriptorJsonHelp<T> {
    private final BeanDescriptor<T> desc;
    private final InheritInfo inheritInfo;

    public BeanDescriptorJsonHelp(BeanDescriptor<T> desc) {
        this.desc = desc;
        this.inheritInfo = desc.inheritInfo;
    }

    public void jsonWrite(WriteJson writeJson, EntityBean bean, String key) throws IOException {
        writeJson.writeStartObject(key);
        if (this.inheritInfo == null) {
            this.jsonWriteProperties(writeJson, bean);
        } else {
            InheritInfo localInheritInfo = this.inheritInfo.readType(bean.getClass());
            String discValue = localInheritInfo.getDiscriminatorStringValue();
            String discColumn = localInheritInfo.getDiscriminatorColumn();
            writeJson.gen().writeStringField(discColumn, discValue);
            BeanDescriptor<?> localDescriptor = localInheritInfo.getBeanDescriptor();
            localDescriptor.jsonWriteProperties(writeJson, bean);
        }
        writeJson.writeEndObject();
    }

    protected void jsonWriteProperties(WriteJson writeJson, EntityBean bean) throws IOException {
        WriteJson.WriteBean writeBean = writeJson.createWriteBean(this.desc, bean);
        writeBean.write(writeJson);
    }

    public T jsonRead(JsonParser parser, String path) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            JsonToken token = parser.nextToken();
            if (JsonToken.VALUE_NULL == token || JsonToken.END_ARRAY == token) {
                return null;
            }
            if (JsonToken.START_OBJECT != token) {
                throw new JsonParseException("Unexpected token " + token + " - expecting start_object", parser.getCurrentLocation());
            }
        }
        if (this.desc.inheritInfo == null) {
            return this.jsonReadObject(parser, path);
        }
        String discColumn = this.inheritInfo.getRoot().getDiscriminatorColumn();
        if (parser.nextToken() != JsonToken.FIELD_NAME) {
            String msg = "Error reading inheritance discriminator - expected [" + discColumn + "] but no json key?";
            throw new JsonParseException(msg, parser.getCurrentLocation());
        }
        String propName = parser.getCurrentName();
        if (!propName.equalsIgnoreCase(discColumn)) {
            BeanProperty property = this.desc.getBeanProperty(propName);
            if (property != null) {
                EntityBean bean = this.desc.createEntityBean();
                property.jsonRead(parser, bean);
                return this.jsonReadProperties(parser, bean);
            }
            String msg = "Error reading inheritance discriminator, expected property [" + discColumn + "] but got [" + propName + "] ?";
            throw new JsonParseException(msg, parser.getCurrentLocation());
        }
        String discValue = parser.nextTextValue();
        InheritInfo localInheritInfo = this.inheritInfo.readType(discValue);
        BeanDescriptor<?> localDescriptor = localInheritInfo.getBeanDescriptor();
        return (T)localDescriptor.jsonReadObject(parser, path);
    }

    protected T jsonReadObject(JsonParser parser, String path) throws IOException {
        EntityBean bean = this.desc.createEntityBean();
        return this.jsonReadProperties(parser, bean);
    }

    protected T jsonReadProperties(JsonParser parser, EntityBean bean) throws IOException {
        JsonToken event;
        while (JsonToken.FIELD_NAME == (event = parser.nextToken())) {
            String key = parser.getCurrentName();
            BeanProperty p = this.desc.getBeanProperty(key);
            if (p != null) {
                p.jsonRead(parser, bean);
                continue;
            }
            EJson.parse(parser);
        }
        if (JsonToken.END_OBJECT != event) {
            throw new RuntimeException("Unexpected token " + event + " - expecting key or end_object at: " + parser.getCurrentLocation());
        }
        return (T)bean;
    }
}

