/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Query;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionAdd;
import com.avaje.ebean.bean.BeanCollectionLoader;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanMap;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BeanMapHelp<T>
implements BeanCollectionHelp<T> {
    private final BeanPropertyAssocMany<T> many;
    private final BeanDescriptor<T> targetDescriptor;
    private final String propertyName;
    private final BeanProperty beanProperty;
    private BeanCollectionLoader loader;

    public BeanMapHelp(BeanDescriptor<T> targetDescriptor, String mapKey) {
        this.targetDescriptor = targetDescriptor;
        this.beanProperty = targetDescriptor.getBeanProperty(mapKey);
        this.many = null;
        this.propertyName = null;
    }

    public BeanMapHelp(BeanPropertyAssocMany<T> many) {
        this.many = many;
        this.targetDescriptor = many.getTargetDescriptor();
        this.propertyName = many.getName();
        this.beanProperty = this.targetDescriptor.getBeanProperty(many.getMapKey());
    }

    @Override
    public void setLoader(BeanCollectionLoader loader) {
        this.loader = loader;
    }

    @Override
    public BeanCollectionAdd getBeanCollectionAdd(Object bc, String mapKey) {
        if (mapKey == null) {
            mapKey = this.many.getMapKey();
        }
        BeanProperty beanProp = this.targetDescriptor.getBeanProperty(mapKey);
        if (bc instanceof BeanMap) {
            BeanMap bm = (BeanMap)bc;
            Map<Object, Object> actualMap = bm.getActualMap();
            if (actualMap == null) {
                actualMap = new LinkedHashMap();
                bm.setActualMap(actualMap);
            }
            return new Adder(beanProp, actualMap);
        }
        throw new RuntimeException("Unhandled type " + bc);
    }

    @Override
    public BeanCollection<T> createEmptyNoParent() {
        return new BeanMap();
    }

    @Override
    public BeanCollection<T> createEmpty(EntityBean ownerBean) {
        BeanMap beanMap = new BeanMap(this.loader, ownerBean, this.propertyName);
        if (this.many != null) {
            beanMap.setModifyListening(this.many.getModifyListenMode());
        }
        return beanMap;
    }

    @Override
    public void add(BeanCollection<?> collection, EntityBean bean) {
        Object keyValue = this.beanProperty.getValueIntercept(bean);
        ((BeanMap)collection).internalPut(keyValue, bean);
    }

    @Override
    public BeanCollection<T> createReference(EntityBean parentBean) {
        BeanMap beanMap = new BeanMap(this.loader, parentBean, this.propertyName);
        if (this.many != null) {
            beanMap.setModifyListening(this.many.getModifyListenMode());
        }
        return beanMap;
    }

    @Override
    public void refresh(EbeanServer server, Query<?> query, Transaction t, EntityBean parentBean) {
        BeanMap newBeanMap = (BeanMap)server.findMap(query, t);
        this.refresh(newBeanMap, parentBean);
    }

    @Override
    public void refresh(BeanCollection<?> bc, EntityBean parentBean) {
        BeanMap newBeanMap = (BeanMap)bc;
        Map current = (Map)this.many.getValue(parentBean);
        newBeanMap.setModifyListening(this.many.getModifyListenMode());
        if (current == null) {
            this.many.setValue(parentBean, newBeanMap);
        } else if (current instanceof BeanMap) {
            BeanMap currentBeanMap = (BeanMap)current;
            currentBeanMap.setActualMap(newBeanMap.getActualMap());
            currentBeanMap.setModifyListening(this.many.getModifyListenMode());
        } else {
            this.many.setValue(parentBean, newBeanMap);
        }
    }

    @Override
    public void jsonWrite(WriteJson ctx, String name, Object collection, boolean explicitInclude) throws IOException {
        Map map;
        if (collection instanceof BeanCollection) {
            BeanMap bc = (BeanMap)collection;
            if (!bc.isPopulated()) {
                if (explicitInclude) {
                    bc.size();
                } else {
                    return;
                }
            }
            map = bc.getActualMap();
        } else {
            map = (Map)collection;
        }
        ctx.writeStartArray(name);
        for (Map.Entry entry : map.entrySet()) {
            this.targetDescriptor.jsonWrite(ctx, (EntityBean)entry.getValue());
        }
        ctx.writeEndArray();
    }

    static class Adder
    implements BeanCollectionAdd {
        private final BeanProperty beanProperty;
        private final Map<Object, Object> map;

        Adder(BeanProperty beanProperty, Map<Object, Object> map) {
            this.beanProperty = beanProperty;
            this.map = map;
        }

        @Override
        public void addBean(EntityBean bean) {
            Object keyValue = this.beanProperty.getValue(bean);
            this.map.put(keyValue, bean);
        }
    }
}

