/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.config.ScalarTypeConverter;
import com.avaje.ebean.text.json.EJson;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorMap;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompoundRoot;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyCompound;
import com.avaje.ebeaninternal.server.el.ElPropertyChainBuilder;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.query.SqlBeanLoad;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.avaje.ebeaninternal.server.type.CtCompoundProperty;
import com.avaje.ebeaninternal.server.type.CtCompoundPropertyElAdapter;
import com.avaje.ebeaninternal.server.type.CtCompoundType;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BeanPropertyCompound
extends BeanProperty {
    private final CtCompoundType<?> compoundType;
    private final ScalarTypeConverter typeConverter;
    private final BeanProperty[] scalarProperties;
    private final LinkedHashMap<String, BeanProperty> propertyMap = new LinkedHashMap();
    private final LinkedHashMap<String, CtCompoundPropertyElAdapter> nonScalarMap = new LinkedHashMap();
    private final BeanPropertyCompoundRoot root;

    public BeanPropertyCompound(BeanDescriptorMap owner, BeanDescriptor<?> descriptor, DeployBeanPropertyCompound deploy) {
        super(owner, descriptor, deploy);
        this.compoundType = deploy.getCompoundType();
        this.typeConverter = deploy.getTypeConverter();
        this.root = deploy.getFlatProperties(owner, descriptor);
        this.scalarProperties = this.root.getScalarProperties();
        for (int i = 0; i < this.scalarProperties.length; ++i) {
            this.propertyMap.put(this.scalarProperties[i].getName(), this.scalarProperties[i]);
        }
        List<CtCompoundProperty> nonScalarPropsList = this.root.getNonScalarProperties();
        for (int i = 0; i < nonScalarPropsList.size(); ++i) {
            CtCompoundProperty ctProp = nonScalarPropsList.get(i);
            CtCompoundPropertyElAdapter adapter = new CtCompoundPropertyElAdapter(ctProp);
            this.nonScalarMap.put(ctProp.getRelativeName(), adapter);
        }
    }

    @Override
    public void initialise() {
        if (!this.isTransient && this.compoundType == null) {
            String msg = "No cvoInternalType assigned to " + this.descriptor.getFullName() + "." + this.getName();
            throw new RuntimeException(msg);
        }
    }

    @Override
    public void setDeployOrder(int deployOrder) {
        this.deployOrder = deployOrder;
        for (CtCompoundPropertyElAdapter adapter : this.nonScalarMap.values()) {
            adapter.setDeployOrder(deployOrder);
        }
    }

    @Override
    public ElPropertyValue buildElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        if (chain == null) {
            chain = new ElPropertyChainBuilder(true, propName);
        }
        chain.add(this);
        BeanProperty p = this.propertyMap.get(remainder);
        if (p != null) {
            return chain.add(p).build();
        }
        CtCompoundPropertyElAdapter elAdapter = this.nonScalarMap.get(remainder);
        if (elAdapter == null) {
            throw new RuntimeException("property [" + remainder + "] not found in " + this.getFullBeanName());
        }
        return chain.add(elAdapter).build();
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        if (!this.isTransient) {
            for (int i = 0; i < this.scalarProperties.length; ++i) {
                this.scalarProperties[i].appendSelect(ctx, subQuery);
            }
        }
    }

    public BeanProperty[] getScalarProperties() {
        return this.scalarProperties;
    }

    @Override
    public Object readSet(DbReadContext ctx, EntityBean bean, Class<?> type) throws SQLException {
        boolean assignable = type == null || this.owningType.isAssignableFrom(type);
        Object v = this.compoundType.read(ctx.getDataReader());
        if (assignable) {
            this.setValue(bean, v);
        }
        return v;
    }

    @Override
    public Object read(DbReadContext ctx) throws SQLException {
        Object v = this.compoundType.read(ctx.getDataReader());
        if (this.typeConverter != null) {
            v = this.typeConverter.wrapValue(v);
        }
        return v;
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
        this.compoundType.loadIgnore(ctx.getDataReader());
    }

    @Override
    public void load(SqlBeanLoad sqlBeanLoad) throws SQLException {
        sqlBeanLoad.load(this);
    }

    @Override
    public Object elGetReference(EntityBean bean) {
        return bean;
    }

    @Override
    public void jsonWrite(WriteJson ctx, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        Object value = this.getValueIntercept(bean);
        if (value == null) {
            ctx.writeNull(this.name);
        } else {
            this.compoundType.jsonWrite(ctx, value, this.name);
        }
    }

    @Override
    public void jsonRead(JsonParser ctx, EntityBean bean) throws IOException {
        if (!this.jsonDeserialize) {
            return;
        }
        Object value = EJson.parse(ctx);
        if (value == null) {
            this.setValue(bean, null);
        } else {
            Map map = (Map)value;
            Object objValue = this.compoundType.jsonConvert(map);
            this.setValue(bean, objValue);
        }
    }
}

