/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.config.ScalarTypeConverter;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompoundRoot;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.type.CtCompoundProperty;

public class BeanPropertyCompoundScalar
extends BeanProperty {
    private final BeanPropertyCompoundRoot rootProperty;
    private final CtCompoundProperty ctProperty;
    private final ScalarTypeConverter typeConverter;

    public BeanPropertyCompoundScalar(BeanPropertyCompoundRoot rootProperty, DeployBeanProperty scalarDeploy, CtCompoundProperty ctProperty, ScalarTypeConverter<?, ?> typeConverter) {
        super(scalarDeploy);
        this.rootProperty = rootProperty;
        this.ctProperty = ctProperty;
        this.typeConverter = typeConverter;
    }

    @Override
    public Object getValueObject(Object compoundValue) {
        if (this.typeConverter != null) {
            compoundValue = this.typeConverter.unwrapValue(compoundValue);
        }
        return this.ctProperty.getValue(compoundValue);
    }

    @Override
    public Object getValue(EntityBean valueObject) {
        EntityBean val = valueObject;
        if (this.typeConverter != null) {
            val = this.typeConverter.unwrapValue(val);
        }
        return this.ctProperty.getValue(val);
    }

    @Override
    public void setValue(EntityBean bean, Object value) {
        this.setValueInCompound(bean, value, false);
    }

    public void setValueInCompound(EntityBean bean, Object value, boolean intercept) {
        Object compoundValue = this.ctProperty.setValue(bean, value);
        if (compoundValue != null) {
            if (this.typeConverter != null) {
                compoundValue = this.typeConverter.wrapValue(compoundValue);
            }
            if (intercept) {
                this.rootProperty.setRootValueIntercept(bean, compoundValue);
            } else {
                this.rootProperty.setRootValue(bean, compoundValue);
            }
        }
    }

    @Override
    public void setValueIntercept(EntityBean bean, Object value) {
        this.setValueInCompound(bean, value, true);
    }

    @Override
    public Object getValueIntercept(EntityBean bean) {
        return this.getValue(bean);
    }

    @Override
    public Object elGetReference(EntityBean bean) {
        return this.getValue(bean);
    }

    @Override
    public Object elGetValue(EntityBean bean) {
        return this.getValue(bean);
    }

    @Override
    public void elSetValue(EntityBean bean, Object value, boolean populate) {
        super.elSetValue(bean, value, populate);
    }
}

