/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanPersistListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ChainedBeanPersistListener
implements BeanPersistListener {
    private final List<BeanPersistListener> list;
    private final BeanPersistListener[] chain;

    public ChainedBeanPersistListener(BeanPersistListener c1, BeanPersistListener c2) {
        this(ChainedBeanPersistListener.addList(c1, c2));
    }

    @Override
    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    private static List<BeanPersistListener> addList(BeanPersistListener c1, BeanPersistListener c2) {
        ArrayList<BeanPersistListener> addList = new ArrayList<BeanPersistListener>(2);
        addList.add(c1);
        addList.add(c2);
        return addList;
    }

    public ChainedBeanPersistListener(List<BeanPersistListener> list) {
        this.list = list;
        this.chain = list.toArray(new BeanPersistListener[list.size()]);
    }

    public ChainedBeanPersistListener register(BeanPersistListener c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>();
        newList.addAll(this.list);
        newList.add(c);
        return new ChainedBeanPersistListener(newList);
    }

    public ChainedBeanPersistListener deregister(BeanPersistListener c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>();
        newList.addAll(this.list);
        newList.remove(c);
        return new ChainedBeanPersistListener(newList);
    }

    @Override
    public boolean deleted(Object bean) {
        boolean notifyCluster = false;
        for (int i = 0; i < this.chain.length; ++i) {
            if (!this.chain[i].deleted(bean)) continue;
            notifyCluster = true;
        }
        return notifyCluster;
    }

    @Override
    public boolean inserted(Object bean) {
        boolean notifyCluster = false;
        for (int i = 0; i < this.chain.length; ++i) {
            if (!this.chain[i].inserted(bean)) continue;
            notifyCluster = true;
        }
        return notifyCluster;
    }

    @Override
    public void remoteDelete(Object id) {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].remoteDelete(id);
        }
    }

    @Override
    public void remoteInsert(Object id) {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].remoteInsert(id);
        }
    }

    @Override
    public void remoteUpdate(Object id) {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].remoteUpdate(id);
        }
    }

    @Override
    public boolean updated(Object bean, Set<String> updatedProperties) {
        boolean notifyCluster = false;
        for (int i = 0; i < this.chain.length; ++i) {
            if (!this.chain[i].updated(bean, updatedProperties)) continue;
            notifyCluster = true;
        }
        return notifyCluster;
    }
}

