/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.deploy.BeanCascadeInfo;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoin;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlBeanLoad;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import java.sql.SQLException;
import java.util.LinkedHashMap;

public final class TableJoin {
    private final boolean importedPrimaryKey;
    private final String table;
    private final SqlJoinType type;
    private final BeanCascadeInfo cascadeInfo;
    private final InheritInfo inheritInfo;
    private final BeanProperty[] properties;
    private final TableJoinColumn[] columns;
    private final int queryHash;

    public TableJoin(DeployTableJoin deploy, LinkedHashMap<String, BeanProperty> propMap) {
        this.importedPrimaryKey = deploy.isImportedPrimaryKey();
        this.table = InternString.intern(deploy.getTable());
        this.type = deploy.getType();
        this.cascadeInfo = deploy.getCascadeInfo();
        this.inheritInfo = deploy.getInheritInfo();
        DeployTableJoinColumn[] deployCols = deploy.columns();
        this.columns = new TableJoinColumn[deployCols.length];
        for (int i = 0; i < deployCols.length; ++i) {
            this.columns[i] = new TableJoinColumn(deployCols[i]);
        }
        DeployBeanProperty[] deployProps = deploy.properties();
        if (deployProps.length > 0 && propMap == null) {
            throw new NullPointerException("propMap is null?");
        }
        this.properties = new BeanProperty[deployProps.length];
        for (int i = 0; i < deployProps.length; ++i) {
            BeanProperty prop;
            this.properties[i] = prop = propMap.get(deployProps[i].getName());
        }
        this.queryHash = this.calcQueryHash();
    }

    private int calcQueryHash() {
        int hc = this.type.hashCode();
        hc = hc * 31 + (this.table == null ? 0 : this.table.hashCode());
        for (int i = 0; i < this.columns.length; ++i) {
            hc = hc * 31 + this.columns[i].queryHash();
        }
        return hc;
    }

    public int queryHash() {
        return this.queryHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append((Object)this.type).append(" ").append(this.table).append(" ");
        for (int i = 0; i < this.columns.length; ++i) {
            sb.append(this.columns[i]).append(" ");
        }
        return sb.toString();
    }

    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
        int x = this.properties.length;
        for (int i = 0; i < x; ++i) {
            this.properties[i].appendSelect(ctx, subQuery);
        }
    }

    public void load(SqlBeanLoad sqlBeanLoad) throws SQLException {
        int x = this.properties.length;
        for (int i = 0; i < x; ++i) {
            this.properties[i].load(sqlBeanLoad);
        }
    }

    public Object readSet(DbReadContext ctx, EntityBean bean, Class<?> type) throws SQLException {
        int x = this.properties.length;
        for (int i = 0; i < x; ++i) {
            this.properties[i].readSet(ctx, bean, type);
        }
        return null;
    }

    public boolean isImportedPrimaryKey() {
        return this.importedPrimaryKey;
    }

    public BeanCascadeInfo getCascadeInfo() {
        return this.cascadeInfo;
    }

    public TableJoinColumn[] columns() {
        return this.columns;
    }

    public BeanProperty[] properties() {
        return this.properties;
    }

    public String getTable() {
        return this.table;
    }

    public SqlJoinType getType() {
        return this.type;
    }

    public boolean isOuterJoin() {
        return this.type == SqlJoinType.OUTER;
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String prefix, DbSqlContext ctx) {
        String[] names = SplitName.split(prefix);
        String a1 = ctx.getTableAlias(names[0]);
        String a2 = ctx.getTableAlias(prefix);
        return this.addJoin(joinType, a1, a2, ctx);
    }

    public SqlJoinType addJoin(SqlJoinType joinType, String a1, String a2, DbSqlContext ctx) {
        String inheritance = this.inheritInfo != null ? this.inheritInfo.getWhere() : null;
        String joinLiteral = joinType.getLiteral(this.type);
        ctx.addJoin(joinLiteral, this.table, this.columns(), a1, a2, inheritance);
        return joinType.autoToOuter(this.type);
    }
}

