/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy.meta;

import com.avaje.ebeaninternal.server.deploy.BeanCascadeInfo;
import com.avaje.ebeaninternal.server.deploy.BeanTable;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import java.util.ArrayList;
import javax.persistence.JoinColumn;

public class DeployTableJoin {
    private boolean importedPrimaryKey;
    private String table;
    private SqlJoinType type = SqlJoinType.INNER;
    private ArrayList<DeployBeanProperty> properties = new ArrayList();
    private ArrayList<DeployTableJoinColumn> columns = new ArrayList(4);
    private BeanCascadeInfo cascadeInfo = new BeanCascadeInfo();
    private InheritInfo inheritInfo;

    public String toString() {
        return (Object)((Object)this.type) + " " + this.table + " " + this.columns;
    }

    public boolean isImportedPrimaryKey() {
        return this.importedPrimaryKey;
    }

    public void setImportedPrimaryKey(boolean importedPrimaryKey) {
        this.importedPrimaryKey = importedPrimaryKey;
    }

    public boolean hasJoinColumns() {
        return this.columns.size() > 0;
    }

    public BeanCascadeInfo getCascadeInfo() {
        return this.cascadeInfo;
    }

    public void setColumns(DeployTableJoinColumn[] cols, boolean reverse) {
        this.columns = new ArrayList();
        for (int i = 0; i < cols.length; ++i) {
            this.addJoinColumn(cols[i].copy(reverse));
        }
    }

    public void addJoinColumn(DeployTableJoinColumn pair) {
        this.columns.add(pair);
    }

    public void addJoinColumn(boolean order, JoinColumn jc, BeanTable beanTable) {
        if (!"".equals(jc.table())) {
            this.setTable(jc.table());
        }
        if (!"".equals(jc.name()) || !"".equals(jc.referencedColumnName())) {
            this.addJoinColumn(new DeployTableJoinColumn(order, jc, beanTable));
        }
    }

    public void addJoinColumn(boolean order, JoinColumn[] jcArray, BeanTable beanTable) {
        for (int i = 0; i < jcArray.length; ++i) {
            this.addJoinColumn(order, jcArray[i], beanTable);
        }
    }

    public DeployTableJoinColumn[] columns() {
        return this.columns.toArray(new DeployTableJoinColumn[this.columns.size()]);
    }

    public DeployBeanProperty[] properties() {
        return this.properties.toArray(new DeployBeanProperty[this.properties.size()]);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public SqlJoinType getType() {
        return this.type;
    }

    public boolean isOuterJoin() {
        return this.type == SqlJoinType.OUTER;
    }

    public void setType(SqlJoinType type) {
        this.type = type;
    }

    public DeployTableJoin createInverse(String tableName) {
        DeployTableJoin inverse = new DeployTableJoin();
        return this.copyInternal(inverse, true, tableName, true);
    }

    public DeployTableJoin copyTo(DeployTableJoin destJoin, boolean reverse, String tableName) {
        return this.copyInternal(destJoin, reverse, tableName, true);
    }

    public DeployTableJoin copyWithoutType(DeployTableJoin destJoin, boolean reverse, String tableName) {
        return this.copyInternal(destJoin, reverse, tableName, false);
    }

    private DeployTableJoin copyInternal(DeployTableJoin destJoin, boolean reverse, String tableName, boolean withType) {
        destJoin.setTable(tableName);
        if (withType) {
            destJoin.setType(this.type);
        }
        destJoin.setColumns(this.columns(), reverse);
        return destJoin;
    }

    public InheritInfo getInheritInfo() {
        return this.inheritInfo;
    }

    public void setInheritInfo(InheritInfo inheritInfo) {
        this.inheritInfo = inheritInfo;
    }
}

