/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import java.util.Map;

class AllEqualsExpression
implements SpiExpression {
    private static final long serialVersionUID = -8691773558205937025L;
    private final Map<String, Object> propMap;

    AllEqualsExpression(Map<String, Object> propMap) {
        this.propMap = propMap;
    }

    protected String name(String propName) {
        return propName;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        if (this.propMap != null) {
            for (String propertyName : this.propMap.keySet()) {
                ElPropertyDeploy elProp = desc.getElPropertyDeploy(this.name(propertyName));
                if (elProp == null || !elProp.containsMany()) continue;
                manyWhereJoin.add(elProp);
            }
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.propMap.isEmpty()) {
            return;
        }
        for (Object value : this.propMap.values()) {
            if (value == null) continue;
            request.addBindValue(value);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.propMap.isEmpty()) {
            return;
        }
        request.append("(");
        int count = 0;
        for (Map.Entry<String, Object> entry : this.propMap.entrySet()) {
            Object value = entry.getValue();
            String propName = entry.getKey();
            if (count > 0) {
                request.append("and ");
            }
            request.append(this.name(propName));
            if (value == null) {
                request.append(" is null ");
            } else {
                request.append(" = ? ");
            }
            ++count;
        }
        request.append(")");
    }

    @Override
    public void queryAutoFetchHash(HashQueryPlanBuilder builder) {
        builder.add(AllEqualsExpression.class);
        for (Map.Entry<String, Object> entry : this.propMap.entrySet()) {
            Object value = entry.getValue();
            String propName = entry.getKey();
            builder.add(propName).add(value == null ? 0 : 1);
            builder.bind(value == null ? 0 : 1);
        }
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.queryAutoFetchHash(builder);
    }

    @Override
    public int queryBindHash() {
        int hc = 31;
        for (Object value : this.propMap.values()) {
            hc = hc * 31 + (value == null ? 0 : value.hashCode());
        }
        return hc;
    }
}

