/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.LikeType;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;

class LikeExpression
extends AbstractExpression {
    private static final long serialVersionUID = -5398151809111172380L;
    private final String val;
    private final boolean caseInsensitive;
    private final LikeType type;

    LikeExpression(String propertyName, String value, boolean caseInsensitive, LikeType type) {
        super(propertyName);
        this.caseInsensitive = caseInsensitive;
        this.type = type;
        this.val = value;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
            request.addBindValue(encryptKey);
        }
        String bindValue = LikeExpression.getValue(this.val, this.caseInsensitive, this.type);
        request.addBindValue(bindValue);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String propertyName;
        String pname = propertyName = this.getPropertyName();
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.getBeanProperty().getDecryptProperty(propertyName);
        }
        if (this.caseInsensitive) {
            request.append("lower(").append(pname).append(")");
        } else {
            request.append(pname);
        }
        if (this.type.equals((Object)LikeType.EQUAL_TO)) {
            request.append(" = ? ");
        } else {
            request.appendLike();
        }
    }

    @Override
    public void queryAutoFetchHash(HashQueryPlanBuilder builder) {
        builder.add(LikeExpression.class).add(this.caseInsensitive).add(this.propName);
        builder.bind(1);
    }

    @Override
    public void queryPlanHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        this.queryAutoFetchHash(builder);
    }

    @Override
    public int queryBindHash() {
        return this.val.hashCode();
    }

    private static String getValue(String value, boolean caseInsensitive, LikeType type) {
        if (caseInsensitive) {
            value = value.toLowerCase();
        }
        switch (type) {
            case RAW: {
                return value;
            }
            case STARTS_WITH: {
                return value + "%";
            }
            case ENDS_WITH: {
                return "%" + value;
            }
            case CONTAINS: {
                return "%" + value + "%";
            }
            case EQUAL_TO: {
                return value;
            }
        }
        throw new RuntimeException("LikeType " + (Object)((Object)type) + " missed?");
    }
}

