/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib;

import com.avaje.ebean.common.BootupEbeanManager;
import com.avaje.ebeaninternal.api.ClassUtil;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.lib.ShutdownHook;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownManager.class);
    static final List<SpiEbeanServer> servers = new ArrayList<SpiEbeanServer>();
    static final ShutdownHook shutdownHook = new ShutdownHook();
    static boolean stopping;
    static BootupEbeanManager serverFactory;

    private ShutdownManager() {
    }

    public static void registerServerFactory(BootupEbeanManager factory) {
        serverFactory = factory;
    }

    public static void touch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStopping() {
        List<SpiEbeanServer> list = servers;
        synchronized (list) {
            return stopping;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void deregisterShutdownHook() {
        List<SpiEbeanServer> list = servers;
        synchronized (list) {
            block5: {
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
                catch (IllegalStateException ex) {
                    if (ex.getMessage().equals("Shutdown in progress")) break block5;
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerShutdownHook() {
        List<SpiEbeanServer> list = servers;
        synchronized (list) {
            block5: {
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
                catch (IllegalStateException ex) {
                    if (ex.getMessage().equals("Shutdown in progress")) break block5;
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        List<SpiEbeanServer> list = servers;
        synchronized (list) {
            if (stopping) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Shutting down");
            }
            stopping = true;
            ShutdownManager.deregisterShutdownHook();
            String shutdownRunner = System.getProperty("ebean.shutdown.runnable");
            if (shutdownRunner != null) {
                try {
                    Runnable r = (Runnable)ClassUtil.newInstance(shutdownRunner);
                    r.run();
                }
                catch (Exception e) {
                    logger.error("Error running custom shutdown runnable", (Throwable)e);
                }
            }
            if (serverFactory != null) {
                serverFactory.shutdown();
            }
            for (SpiEbeanServer server : servers) {
                try {
                    server.shutdownManaged();
                }
                catch (Exception ex) {
                    logger.error("Error executing shutdown runnable", (Throwable)ex);
                    ex.printStackTrace();
                }
            }
            if ("true".equalsIgnoreCase(System.getProperty("ebean.datasource.deregisterAllDrivers", "false"))) {
                ShutdownManager.deregisterAllJdbcDrivers();
            }
        }
    }

    private static void deregisterAllJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                logger.info("Deregistering jdbc driver: " + driver);
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                logger.error("Error deregistering driver " + driver, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEbeanServer(SpiEbeanServer server) {
        List<SpiEbeanServer> list = servers;
        synchronized (list) {
            servers.add(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterEbeanServer(SpiEbeanServer server) {
        List<SpiEbeanServer> list = servers;
        synchronized (list) {
            servers.remove(server);
        }
    }

    static {
        ShutdownManager.registerShutdownHook();
    }
}

