/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.loadcontext;

import com.avaje.ebean.bean.BeanLoader;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.LoadBeanBuffer;
import com.avaje.ebeaninternal.api.LoadBeanContext;
import com.avaje.ebeaninternal.api.LoadBeanRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.loadcontext.DLoadBaseContext;
import com.avaje.ebeaninternal.server.loadcontext.DLoadContext;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DLoadBeanContext
extends DLoadBaseContext
implements LoadBeanContext {
    private List<LoadBuffer> bufferList;
    private LoadBuffer currentBuffer;

    public DLoadBeanContext(DLoadContext parent, BeanDescriptor<?> desc, String path, int defaultBatchSize, OrmQueryProperties queryProps) {
        super(parent, desc, path, defaultBatchSize, queryProps);
        this.bufferList = !this.queryFetch ? null : new ArrayList();
        this.currentBuffer = this.createBuffer(this.firstBatchSize);
    }

    public void clear() {
        if (this.bufferList != null) {
            this.bufferList.clear();
        }
        this.currentBuffer = this.createBuffer(this.secondaryBatchSize);
    }

    protected void configureQuery(SpiQuery<?> query, String lazyLoadProperty) {
        if (this.parent.isReadOnly() != null) {
            query.setReadOnly(this.parent.isReadOnly());
        }
        query.setParentNode(this.objectGraphNode);
        query.setLazyLoadProperty(lazyLoadProperty);
        if (this.queryProps != null) {
            this.queryProps.configureBeanQuery(query);
        }
        if (this.parent.isUseAutofetchManager()) {
            query.setAutofetch(true);
        }
    }

    protected void register(EntityBeanIntercept ebi) {
        if (this.currentBuffer.isFull()) {
            this.currentBuffer = this.createBuffer(this.secondaryBatchSize);
        }
        ebi.setBeanLoader(this.currentBuffer, this.getPersistenceContext());
        this.currentBuffer.add(ebi);
    }

    private LoadBuffer createBuffer(int size) {
        LoadBuffer buffer = new LoadBuffer(this, size);
        if (this.bufferList != null) {
            this.bufferList.add(buffer);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSecondaryQuery(OrmQueryRequest<?> parentRequest) {
        if (!this.queryFetch) {
            throw new IllegalStateException("Not expecting loadSecondaryQuery() to be called?");
        }
        DLoadBeanContext dLoadBeanContext = this;
        synchronized (dLoadBeanContext) {
            if (this.bufferList != null) {
                for (LoadBuffer loadBuffer : this.bufferList) {
                    if (!loadBuffer.list.isEmpty()) {
                        boolean loadCache = false;
                        LoadBeanRequest req = new LoadBeanRequest(loadBuffer, parentRequest, false, null, loadCache);
                        this.parent.getEbeanServer().loadBean(req);
                        if (!this.queryProps.isQueryFetchAll()) break;
                    }
                    this.bufferList = null;
                }
            }
        }
    }

    public static class LoadBuffer
    implements BeanLoader,
    LoadBeanBuffer {
        private final DLoadBeanContext context;
        private final int batchSize;
        private final List<EntityBeanIntercept> list;
        private PersistenceContext persistenceContext;

        public LoadBuffer(DLoadBeanContext context, int batchSize) {
            this.context = context;
            this.batchSize = batchSize;
            this.list = new ArrayList<EntityBeanIntercept>(batchSize);
        }

        @Override
        public int getBatchSize() {
            return this.batchSize;
        }

        public boolean isFull() {
            return this.batchSize == this.list.size();
        }

        public void add(EntityBeanIntercept ebi) {
            if (this.persistenceContext == null) {
                this.persistenceContext = ebi.getPersistenceContext();
            }
            this.list.add(ebi);
        }

        @Override
        public List<EntityBeanIntercept> getBatch() {
            return this.list;
        }

        @Override
        public String getName() {
            return this.context.serverName;
        }

        @Override
        public String getFullPath() {
            return this.context.fullPath;
        }

        @Override
        public BeanDescriptor<?> getBeanDescriptor() {
            return this.context.desc;
        }

        @Override
        public PersistenceContext getPersistenceContext() {
            return this.persistenceContext;
        }

        @Override
        public void configureQuery(SpiQuery<?> query, String lazyLoadProperty) {
            this.context.configureQuery(query, lazyLoadProperty);
        }

        @Override
        public void loadBean(EntityBeanIntercept ebi) {
            if (this.context.desc.lazyLoadMany(ebi)) {
                return;
            }
            if (this.context.hitCache && this.context.desc.cacheBeanLoad(ebi)) {
                this.list.remove(ebi);
                return;
            }
            if (this.context.hitCache) {
                Iterator<EntityBeanIntercept> iterator = this.list.iterator();
                while (iterator.hasNext()) {
                    EntityBeanIntercept bean = iterator.next();
                    if (!this.context.desc.cacheBeanLoad(bean)) continue;
                    iterator.remove();
                }
            }
            LoadBeanRequest req = new LoadBeanRequest(this, true, ebi.getLazyLoadProperty(), this.context.hitCache);
            this.context.desc.getEbeanServer().loadBean(req);
        }
    }
}

