/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.DerivedRelationshipData;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.Message;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.persist.DmlUtil;
import com.avaje.ebeaninternal.server.persist.dml.DmlHandler;
import com.avaje.ebeaninternal.server.persist.dml.InsertMeta;
import com.avaje.ebeaninternal.server.type.DataBind;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertHandler
extends DmlHandler {
    private static final Logger logger = LoggerFactory.getLogger(InsertHandler.class);
    private final InsertMeta meta;
    private final boolean concatinatedKey;
    private boolean useGeneratedKeys;
    private String selectLastInsertedId;

    public InsertHandler(PersistRequestBean<?> persist, InsertMeta meta) {
        super(persist, meta.isEmptyStringToNull());
        this.meta = meta;
        this.concatinatedKey = meta.isConcatinatedKey();
    }

    @Override
    public void bind() throws SQLException {
        boolean withId;
        EntityBean bean;
        BeanDescriptor desc = this.persistRequest.getBeanDescriptor();
        Object idValue = desc.getId(bean = this.persistRequest.getEntityBean());
        boolean bl = withId = !DmlUtil.isNullOrZero(idValue);
        if (!withId) {
            if (this.concatinatedKey) {
                withId = this.meta.deriveConcatenatedId(this.persistRequest);
            } else if (this.meta.supportsGetGeneratedKeys()) {
                this.useGeneratedKeys = true;
            } else {
                this.selectLastInsertedId = this.meta.getSelectLastInsertedId();
            }
        }
        Transaction t = this.persistRequest.getTransaction();
        this.sql = this.meta.getSql(withId);
        PreparedStatement pstmt = this.persistRequest.isBatched() ? this.getPstmt((SpiTransaction)t, this.sql, this.persistRequest, this.useGeneratedKeys) : this.getPstmt((SpiTransaction)t, this.sql, this.useGeneratedKeys);
        this.dataBind = new DataBind(pstmt);
        this.meta.bind(this, bean, withId);
        this.logSql(this.sql);
    }

    @Override
    protected PreparedStatement getPstmt(SpiTransaction t, String sql, boolean useGeneratedKeys) throws SQLException {
        Connection conn = t.getInternalConnection();
        if (useGeneratedKeys) {
            return conn.prepareStatement(sql, this.meta.getIdentityDbColumns());
        }
        return conn.prepareStatement(sql);
    }

    @Override
    public void execute() throws SQLException, OptimisticLockException {
        int rc = this.dataBind.executeUpdate();
        if (this.useGeneratedKeys) {
            this.getGeneratedKeys();
        } else if (this.selectLastInsertedId != null) {
            this.fetchGeneratedKeyUsingSelect();
        }
        this.checkRowCount(rc);
        this.executeDerivedRelationships();
        this.persistRequest.postInsert();
    }

    protected void executeDerivedRelationships() {
        List<DerivedRelationshipData> derivedRelationships = this.persistRequest.getDerivedRelationships();
        if (derivedRelationships != null) {
            SpiEbeanServer ebeanServer = (SpiEbeanServer)this.persistRequest.getEbeanServer();
            for (int i = 0; i < derivedRelationships.size(); ++i) {
                DerivedRelationshipData derivedRelationshipData = derivedRelationships.get(i);
                BeanDescriptor<?> beanDescriptor = ebeanServer.getBeanDescriptor(derivedRelationshipData.getBean().getClass());
                BeanProperty prop = beanDescriptor.getBeanProperty(derivedRelationshipData.getLogicalName());
                EntityBean entityBean = (EntityBean)derivedRelationshipData.getBean();
                entityBean._ebean_getIntercept().markPropertyAsChanged(prop.getPropertyIndex());
                ebeanServer.update(entityBean, (Transaction)this.transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGeneratedKeys() throws SQLException {
        block9: {
            ResultSet rset = this.dataBind.getPstmt().getGeneratedKeys();
            try {
                if (rset.next()) {
                    Object idValue = rset.getObject(1);
                    if (idValue != null) {
                        this.persistRequest.setGeneratedKey(idValue);
                    }
                    break block9;
                }
                throw new PersistenceException(Message.msg("persist.autoinc.norows"));
            }
            finally {
                try {
                    rset.close();
                }
                catch (SQLException ex) {
                    String msg = "Error closing rset for returning generatedKeys?";
                    logger.warn(msg, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchGeneratedKeyUsingSelect() throws SQLException {
        block15: {
            Connection conn = this.transaction.getConnection();
            PreparedStatement stmt = null;
            ResultSet rset = null;
            try {
                stmt = conn.prepareStatement(this.selectLastInsertedId);
                rset = stmt.executeQuery();
                if (rset.next()) {
                    Object idValue = rset.getObject(1);
                    if (idValue != null) {
                        this.persistRequest.setGeneratedKey(idValue);
                    }
                    break block15;
                }
                throw new PersistenceException(Message.msg("persist.autoinc.norows"));
            }
            finally {
                String msg;
                try {
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (SQLException ex) {
                    msg = "Error closing rset for fetchGeneratedKeyUsingSelect?";
                    logger.warn(msg, (Throwable)ex);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    msg = "Error closing stmt for fetchGeneratedKeyUsingSelect?";
                    logger.warn(msg, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void registerDerivedRelationship(DerivedRelationshipData derivedRelationship) {
        this.persistRequest.getTransaction().registerDerivedRelationship(derivedRelationship);
    }
}

