/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.properties;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BeanPropertiesReader {
    private final Map<String, Integer> propertyIndexMap = new HashMap<String, Integer>();
    private final String[] props;

    public BeanPropertiesReader(Class<?> clazz) {
        this.props = this.getProperties(clazz);
        for (int i = 0; i < this.props.length; ++i) {
            this.propertyIndexMap.put(this.props[i], i);
        }
    }

    public String[] getProperties() {
        return this.props;
    }

    public String toString() {
        return Arrays.toString(this.props);
    }

    public Integer getPropertyIndex(String property) {
        return this.propertyIndexMap.get(property);
    }

    private String[] getProperties(Class<?> clazz) {
        try {
            Field field = clazz.getField("_ebean_props");
            return (String[])field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error getting _ebean_props field on type " + clazz, e);
        }
    }
}

