/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.query.SqlTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SqlTree {
    private final SqlTreeNode rootNode;
    private final BeanPropertyAssocMany<?> manyProperty;
    private final String manyPropertyName;
    private final ElPropertyValue manyPropEl;
    private final Set<String> includes;
    private final String summary;
    private final String selectSql;
    private final String fromSql;
    private final BeanProperty[] encryptedProps;
    private final String inheritanceWhereSql;

    public SqlTree(String summary, SqlTreeNode rootNode, String selectSql, String fromSql, String inheritanceWhereSql, BeanProperty[] encryptedProps, BeanPropertyAssocMany<?> manyProperty, String manyPropertyName, ElPropertyValue manyPropEl, Set<String> includes) {
        this.summary = summary;
        this.rootNode = rootNode;
        this.selectSql = selectSql;
        this.fromSql = fromSql;
        this.inheritanceWhereSql = inheritanceWhereSql;
        this.encryptedProps = encryptedProps;
        this.manyProperty = manyProperty;
        this.manyPropertyName = manyPropertyName;
        this.manyPropEl = manyPropEl;
        this.includes = includes;
    }

    public SqlTree(String summary, SqlTreeNode rootNode) {
        this.summary = summary;
        this.rootNode = rootNode;
        this.selectSql = null;
        this.fromSql = null;
        this.inheritanceWhereSql = null;
        this.encryptedProps = null;
        this.manyProperty = null;
        this.manyPropertyName = null;
        this.manyPropEl = null;
        this.includes = null;
    }

    public List<String> buildSelectExpressionChain() {
        ArrayList<String> list = new ArrayList<String>();
        this.rootNode.buildSelectExpressionChain(list);
        return list;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public String getFromSql() {
        return this.fromSql;
    }

    public String getInheritanceWhereSql() {
        return this.inheritanceWhereSql;
    }

    public String getSummary() {
        return this.summary;
    }

    public SqlTreeNode getRootNode() {
        return this.rootNode;
    }

    public BeanPropertyAssocMany<?> getManyProperty() {
        return this.manyProperty;
    }

    public String getManyPropertyName() {
        return this.manyPropertyName;
    }

    public ElPropertyValue getManyPropertyEl() {
        return this.manyPropEl;
    }

    public boolean isManyIncluded() {
        return this.manyProperty != null;
    }

    public BeanProperty[] getEncryptedProps() {
        return this.encryptedProps;
    }
}

