/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.querydefn;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.FetchConfig;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.OrderBy;
import com.avaje.ebean.PagedList;
import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.QueryResultVisitor;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.bean.BeanCollectionTouched;
import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.api.BindParams;
import com.avaje.ebeaninternal.api.HashQuery;
import com.avaje.ebeaninternal.api.HashQueryPlan;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autofetch.AutoFetchManager;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DRawSqlSelect;
import com.avaje.ebeaninternal.server.deploy.DeployNamedQuery;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.expression.SimpleExpression;
import com.avaje.ebeaninternal.server.query.CancelableQuery;
import com.avaje.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetailParser;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import com.avaje.ebeaninternal.util.DefaultExpressionList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public class DefaultOrmQuery<T>
implements SpiQuery<T> {
    private static final long serialVersionUID = 6838006264714672460L;
    private final Class<T> beanType;
    private final transient EbeanServer server;
    private transient BeanCollectionTouched beanCollectionTouched;
    private final transient ExpressionFactory expressionFactory;
    private transient ArrayList<EntityBean> contextAdditions;
    private transient TableJoin includeTableJoin;
    private transient AutoFetchManager autoFetchManager;
    private transient BeanDescriptor<?> beanDescriptor;
    private boolean cancelled;
    private transient CancelableQuery cancelableQuery;
    private String name;
    private SpiQuery.Type type;
    private SpiQuery.Mode mode = SpiQuery.Mode.NORMAL;
    private OrmQueryDetail detail;
    private int maxRows;
    private int firstRow;
    private int lazyLoadBatchSize;
    private String rawWhereClause;
    private OrderBy<T> orderBy;
    private String loadMode;
    private String loadDescription;
    private String generatedSql;
    private String query;
    private String additionalWhere;
    private String additionalHaving;
    private String lazyLoadProperty;
    private String lazyLoadManyPath;
    private boolean distinct;
    private boolean sqlDistinct;
    private boolean futureFetch;
    private List<Object> partialIds;
    private int timeout = -1;
    private String mapKey;
    private Object id;
    private BindParams bindParams;
    private DefaultExpressionList<T> whereExpressions;
    private DefaultExpressionList<T> havingExpressions;
    private int bufferFetchSizeHint;
    private boolean usageProfiling = true;
    private boolean loadBeanCache;
    private Boolean useBeanCache;
    private Boolean useQueryCache;
    private Boolean readOnly;
    private PersistenceContextScope persistenceContextScope;
    private boolean sqlSelect;
    private Boolean autoFetch;
    private boolean forUpdate;
    private boolean autoFetchTuned;
    private boolean logSecondaryQuery;
    private ObjectGraphNode parentNode;
    private BeanPropertyAssocMany<?> lazyLoadForParentsProperty;
    private List<Object> lazyLoadForParentsIds;
    private HashQueryPlan queryPlanHash;
    private transient PersistenceContext persistenceContext;
    private ManyWhereJoins manyWhereJoins;
    private RawSql rawSql;
    private List<SpiQuery<?>> loggedSecondaryQueries;

    public DefaultOrmQuery(Class<T> beanType, EbeanServer server, ExpressionFactory expressionFactory, String query) {
        this.beanType = beanType;
        this.server = server;
        this.expressionFactory = expressionFactory;
        this.detail = new OrmQueryDetail();
        this.name = "";
        if (query != null) {
            this.setQuery(query);
        }
    }

    public DefaultOrmQuery(Class<T> beanType, EbeanServer server, ExpressionFactory expressionFactory, DeployNamedQuery namedQuery) throws PersistenceException {
        this.beanType = beanType;
        this.server = server;
        this.expressionFactory = expressionFactory;
        this.detail = new OrmQueryDetail();
        if (namedQuery == null) {
            this.name = "";
        } else {
            this.name = namedQuery.getName();
            this.sqlSelect = namedQuery.isSqlSelect();
            if (this.sqlSelect) {
                DRawSqlSelect sqlSelect = namedQuery.getSqlSelect();
                this.additionalWhere = sqlSelect.getWhereClause();
                this.additionalHaving = sqlSelect.getHavingClause();
            } else if (namedQuery.isRawSql()) {
                this.rawSql = namedQuery.getRawSql();
            } else {
                this.setQuery(namedQuery.getQuery());
            }
        }
    }

    @Override
    public Query<T> apply(PathProperties pathProperties) {
        pathProperties.apply(this);
        return this;
    }

    @Override
    public void setBeanDescriptor(BeanDescriptor<?> beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
    }

    @Override
    public boolean selectAllForLazyLoadProperty() {
        if (this.lazyLoadProperty != null && !this.detail.containsProperty(this.lazyLoadProperty)) {
            this.detail.select("*");
            return true;
        }
        return false;
    }

    @Override
    public RawSql getRawSql() {
        return this.rawSql;
    }

    @Override
    public DefaultOrmQuery<T> setRawSql(RawSql rawSql) {
        this.rawSql = rawSql;
        return this;
    }

    @Override
    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    @Override
    public Query<T> setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
        return this;
    }

    @Override
    public String getLazyLoadProperty() {
        return this.lazyLoadProperty;
    }

    @Override
    public void setLazyLoadProperty(String lazyLoadProperty) {
        this.lazyLoadProperty = lazyLoadProperty;
    }

    @Override
    public String getLazyLoadManyPath() {
        return this.lazyLoadManyPath;
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    @Override
    public boolean initManyWhereJoins() {
        this.manyWhereJoins = new ManyWhereJoins();
        if (this.whereExpressions != null) {
            this.whereExpressions.containsMany(this.beanDescriptor, this.manyWhereJoins);
        }
        return !this.manyWhereJoins.isEmpty();
    }

    @Override
    public ManyWhereJoins getManyWhereJoins() {
        return this.manyWhereJoins;
    }

    @Override
    public List<OrmQueryProperties> removeQueryJoins() {
        List<OrmQueryProperties> queryJoins = this.detail.removeSecondaryQueries();
        if (queryJoins != null && this.orderBy != null) {
            for (int i = 0; i < queryJoins.size(); ++i) {
                OrmQueryProperties joinPath = queryJoins.get(i);
                List<OrderBy.Property> properties = this.orderBy.getProperties();
                Iterator<OrderBy.Property> it = properties.iterator();
                while (it.hasNext()) {
                    OrderBy.Property property = it.next();
                    if (!property.getProperty().startsWith(joinPath.getPath())) continue;
                    it.remove();
                    joinPath.addSecJoinOrderProperty(property);
                }
            }
        }
        return queryJoins;
    }

    @Override
    public List<OrmQueryProperties> removeLazyJoins() {
        return this.detail.removeSecondaryLazyQueries();
    }

    @Override
    public void setLazyLoadManyPath(String lazyLoadManyPath) {
        this.lazyLoadManyPath = lazyLoadManyPath;
    }

    @Override
    public void convertManyFetchJoinsToQueryJoins(boolean allowOne, int queryBatch) {
        this.detail.convertManyFetchJoinsToQueryJoins(this.beanDescriptor, this.lazyLoadManyPath, allowOne, queryBatch);
    }

    @Override
    public void setSelectId() {
        this.detail.clear();
        this.select(this.beanDescriptor.getIdBinder().getIdProperty());
    }

    @Override
    public void convertWhereNaturalKeyToId(Object idValue) {
        this.whereExpressions = new DefaultExpressionList(this, null);
        this.setId(idValue);
    }

    @Override
    public NaturalKeyBindParam getNaturalKeyBindParam() {
        NaturalKeyBindParam namedBind = null;
        if (this.bindParams != null && (namedBind = this.bindParams.getNaturalKeyBindParam()) == null) {
            return null;
        }
        if (this.whereExpressions != null) {
            SimpleExpression e;
            List<SpiExpression> exprList = this.whereExpressions.internalList();
            if (exprList.size() > 1) {
                return null;
            }
            if (exprList.size() == 0) {
                return namedBind;
            }
            if (namedBind != null) {
                return null;
            }
            SpiExpression se = exprList.get(0);
            if (se instanceof SimpleExpression && (e = (SimpleExpression)se).isOpEquals()) {
                return new NaturalKeyBindParam(e.getPropertyName(), e.getValue());
            }
        }
        return null;
    }

    @Override
    public DefaultOrmQuery<T> copy() {
        DefaultOrmQuery<T> copy = new DefaultOrmQuery<T>(this.beanType, this.server, this.expressionFactory, (String)null);
        copy.name = this.name;
        copy.includeTableJoin = this.includeTableJoin;
        copy.autoFetchManager = this.autoFetchManager;
        copy.query = this.query;
        copy.additionalWhere = this.additionalWhere;
        copy.additionalHaving = this.additionalHaving;
        copy.distinct = this.distinct;
        copy.sqlDistinct = this.sqlDistinct;
        copy.timeout = this.timeout;
        copy.mapKey = this.mapKey;
        copy.id = this.id;
        copy.loadBeanCache = this.loadBeanCache;
        copy.useBeanCache = this.useBeanCache;
        copy.useQueryCache = this.useQueryCache;
        copy.readOnly = this.readOnly;
        copy.sqlSelect = this.sqlSelect;
        if (this.detail != null) {
            copy.detail = this.detail.copy();
        }
        copy.firstRow = this.firstRow;
        copy.maxRows = this.maxRows;
        copy.rawWhereClause = this.rawWhereClause;
        if (this.orderBy != null) {
            copy.orderBy = this.orderBy.copy();
        }
        if (this.bindParams != null) {
            copy.bindParams = this.bindParams.copy();
        }
        if (this.whereExpressions != null) {
            copy.whereExpressions = this.whereExpressions.copy(copy);
        }
        if (this.havingExpressions != null) {
            copy.havingExpressions = this.havingExpressions.copy(copy);
        }
        copy.persistenceContextScope = this.persistenceContextScope;
        copy.usageProfiling = this.usageProfiling;
        copy.autoFetch = this.autoFetch;
        copy.parentNode = this.parentNode;
        copy.forUpdate = this.forUpdate;
        copy.rawSql = this.rawSql;
        copy.rawWhereClause = this.rawWhereClause;
        return copy;
    }

    @Override
    public Query<T> setPersistenceContextScope(PersistenceContextScope scope) {
        this.persistenceContextScope = scope;
        return this;
    }

    @Override
    public PersistenceContextScope getPersistenceContextScope() {
        return this.persistenceContextScope;
    }

    @Override
    public SpiQuery.Type getType() {
        return this.type;
    }

    @Override
    public void setType(SpiQuery.Type type) {
        this.type = type;
    }

    @Override
    public String getLoadDescription() {
        return this.loadDescription;
    }

    @Override
    public String getLoadMode() {
        return this.loadMode;
    }

    @Override
    public void setLoadDescription(String loadMode, String loadDescription) {
        this.loadMode = loadMode;
        this.loadDescription = loadDescription;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public void setLazyLoadForParents(List<Object> parentIds, BeanPropertyAssocMany<?> many) {
        this.lazyLoadForParentsIds = parentIds;
        this.lazyLoadForParentsProperty = many;
    }

    @Override
    public List<Object> getLazyLoadForParentIds() {
        return this.lazyLoadForParentsIds;
    }

    @Override
    public BeanPropertyAssocMany<?> getLazyLoadForParentsProperty() {
        return this.lazyLoadForParentsProperty;
    }

    @Override
    public boolean isDetailEmpty() {
        return this.detail.isEmpty();
    }

    @Override
    public boolean isAutofetchTuned() {
        return this.autoFetchTuned;
    }

    @Override
    public void setAutoFetchTuned(boolean autoFetchTuned) {
        this.autoFetchTuned = autoFetchTuned;
    }

    @Override
    public Boolean isAutofetch() {
        return this.sqlSelect ? Boolean.FALSE : this.autoFetch;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public DefaultOrmQuery<T> setAutoFetch(boolean autoFetch) {
        return this.setAutofetch(autoFetch);
    }

    @Override
    public DefaultOrmQuery<T> setAutofetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    @Override
    public AutoFetchManager getAutoFetchManager() {
        return this.autoFetchManager;
    }

    @Override
    public void setAutoFetchManager(AutoFetchManager autoFetchManager) {
        this.autoFetchManager = autoFetchManager;
    }

    @Override
    public SpiQuery.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(SpiQuery.Mode mode) {
        this.mode = mode;
    }

    @Override
    public boolean isUsageProfiling() {
        return this.usageProfiling;
    }

    @Override
    public void setUsageProfiling(boolean usageProfiling) {
        this.usageProfiling = usageProfiling;
    }

    @Override
    public void setLogSecondaryQuery(boolean logSecondaryQuery) {
        this.logSecondaryQuery = logSecondaryQuery;
    }

    @Override
    public boolean isLogSecondaryQuery() {
        return this.logSecondaryQuery;
    }

    @Override
    public List<SpiQuery<?>> getLoggedSecondaryQueries() {
        return this.loggedSecondaryQueries;
    }

    @Override
    public void logSecondaryQuery(SpiQuery<?> query) {
        if (this.loggedSecondaryQueries == null) {
            this.loggedSecondaryQueries = new ArrayList();
        }
        this.loggedSecondaryQueries.add(query);
    }

    @Override
    public void setParentNode(ObjectGraphNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public ObjectGraphNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public ObjectGraphNode setOrigin(CallStack callStack) {
        ObjectGraphOrigin o = new ObjectGraphOrigin(this.calculateOriginQueryHash(), callStack, this.beanType.getName());
        this.parentNode = new ObjectGraphNode(o, null);
        return this.parentNode;
    }

    private int calculateOriginQueryHash() {
        int hc = this.beanType.getName().hashCode();
        hc = hc * 31 + (this.type == null ? 0 : this.type.ordinal());
        return hc;
    }

    private HashQueryPlan calculateHash(BeanQueryRequest<?> request, HashQueryPlanBuilder builder) {
        if (builder == null) {
            builder = new HashQueryPlanBuilder();
        }
        builder.add(this.type == null ? 0 : this.type.ordinal() + 1);
        builder.add(this.autoFetchTuned).add(this.distinct).add(this.sqlDistinct).add(this.query);
        builder.add(this.firstRow).add(this.maxRows).add(this.orderBy).add(this.forUpdate);
        builder.add(this.rawWhereClause).add(this.additionalWhere).add(this.additionalHaving);
        builder.add(this.mapKey);
        builder.add(this.id != null);
        builder.add(this.rawSql == null ? 0 : this.rawSql.queryHash());
        builder.add(this.includeTableJoin != null ? this.includeTableJoin.queryHash() : 0);
        if (this.detail != null) {
            this.detail.queryPlanHash(request, builder);
        }
        if (this.bindParams != null) {
            this.bindParams.buildQueryPlanHash(builder);
        }
        if (request == null) {
            builder.add(true);
            if (this.whereExpressions != null) {
                this.whereExpressions.queryAutoFetchHash(builder);
            }
            if (this.havingExpressions != null) {
                this.havingExpressions.queryAutoFetchHash(builder);
            }
        } else {
            builder.add(false);
            if (this.whereExpressions != null) {
                this.whereExpressions.queryPlanHash(request, builder);
            }
            if (this.havingExpressions != null) {
                this.havingExpressions.queryPlanHash(request, builder);
            }
        }
        return builder.build();
    }

    @Override
    public HashQueryPlan queryAutofetchHash(HashQueryPlanBuilder builder) {
        return this.calculateHash(null, builder);
    }

    @Override
    public HashQueryPlan queryPlanHash(BeanQueryRequest<?> request) {
        this.queryPlanHash = this.calculateHash(request, null);
        return this.queryPlanHash;
    }

    @Override
    public int queryBindHash() {
        int hc = this.id == null ? 0 : this.id.hashCode();
        hc = hc * 31 + (this.whereExpressions == null ? 0 : this.whereExpressions.queryBindHash());
        hc = hc * 31 + (this.havingExpressions == null ? 0 : this.havingExpressions.queryBindHash());
        hc = hc * 31 + (this.bindParams == null ? 0 : this.bindParams.queryBindHash());
        hc = hc * 31 + (this.contextAdditions == null ? 0 : this.contextAdditions.hashCode());
        return hc;
    }

    @Override
    public HashQuery queryHash() {
        int hc = this.queryBindHash();
        return new HashQuery(this.queryPlanHash, hc);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSqlSelect() {
        return this.sqlSelect;
    }

    @Override
    public boolean isRawSql() {
        return this.rawSql != null;
    }

    @Override
    public String getAdditionalWhere() {
        return this.additionalWhere;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public String getAdditionalHaving() {
        return this.additionalHaving;
    }

    @Override
    public boolean hasMaxRowsOrFirstRow() {
        return this.maxRows > 0 || this.firstRow > 0;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public DefaultOrmQuery<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public Boolean isUseBeanCache() {
        return this.useBeanCache;
    }

    @Override
    public boolean isUseQueryCache() {
        return Boolean.TRUE.equals(this.useQueryCache);
    }

    @Override
    public DefaultOrmQuery<T> setUseCache(boolean useBeanCache) {
        this.useBeanCache = useBeanCache;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setUseQueryCache(boolean useQueryCache) {
        this.useQueryCache = useQueryCache;
        return this;
    }

    @Override
    public boolean isLoadBeanCache() {
        return this.loadBeanCache;
    }

    @Override
    public DefaultOrmQuery<T> setLoadBeanCache(boolean loadBeanCache) {
        this.loadBeanCache = loadBeanCache;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    public DefaultOrmQuery<T> setQuery(String queryString) throws PersistenceException {
        this.query = queryString;
        OrmQueryDetailParser parser = new OrmQueryDetailParser(queryString);
        parser.parse();
        parser.assign(this);
        return this;
    }

    protected void setOrmQueryDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    protected void setRawWhereClause(String rawWhereClause) {
        this.rawWhereClause = rawWhereClause;
    }

    public DefaultOrmQuery<T> setProperties(String columns) {
        return this.select(columns);
    }

    @Override
    public void setDefaultSelectClause() {
        this.detail.setDefaultSelectClause(this.beanDescriptor);
    }

    @Override
    public DefaultOrmQuery<T> select(String columns) {
        this.detail.select(columns);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property) {
        return this.fetch(property, null, null);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, FetchConfig joinConfig) {
        return this.fetch(property, null, joinConfig);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, String columns) {
        return this.fetch(property, columns, null);
    }

    @Override
    public DefaultOrmQuery<T> fetch(String property, String columns, FetchConfig config) {
        this.detail.addFetch(property, columns, config);
        return this;
    }

    @Override
    public List<Object> findIds() {
        return this.server.findIds(this, null);
    }

    @Override
    public int findRowCount() {
        return this.server.findRowCount(this, null);
    }

    @Override
    public void findVisit(QueryResultVisitor<T> visitor) {
        this.server.findVisit(this, visitor, null);
    }

    @Override
    public void findEachWhile(QueryEachWhileConsumer<T> consumer) {
        this.server.findEachWhile(this, consumer, null);
    }

    @Override
    public void findEach(QueryEachConsumer<T> consumer) {
        this.server.findEach(this, consumer, null);
    }

    @Override
    public QueryIterator<T> findIterate() {
        return this.server.findIterate(this, null);
    }

    @Override
    public List<T> findList() {
        return this.server.findList(this, null);
    }

    @Override
    public Set<T> findSet() {
        return this.server.findSet(this, null);
    }

    @Override
    public Map<?, T> findMap() {
        return this.server.findMap(this, null);
    }

    @Override
    public <K> Map<K, T> findMap(String keyProperty, Class<K> keyType) {
        this.setMapKey(keyProperty);
        return this.findMap();
    }

    @Override
    public T findUnique() {
        return this.server.findUnique(this, null);
    }

    @Override
    public FutureIds<T> findFutureIds() {
        return this.server.findFutureIds(this, null);
    }

    @Override
    public FutureList<T> findFutureList() {
        return this.server.findFutureList(this, null);
    }

    @Override
    public FutureRowCount<T> findFutureRowCount() {
        return this.server.findFutureRowCount(this, null);
    }

    @Override
    public PagedList<T> findPagedList(int pageIndex, int pageSize) {
        return this.server.findPagedList(this, null, pageIndex, pageSize);
    }

    @Override
    public DefaultOrmQuery<T> setParameter(int position, Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(position, value);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setParameter(String name, Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(name, value);
        return this;
    }

    @Override
    public OrderBy<T> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public String getRawWhereClause() {
        return this.rawWhereClause;
    }

    @Override
    public OrderBy<T> orderBy() {
        return this.order();
    }

    @Override
    public OrderBy<T> order() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy(this, null);
        }
        return this.orderBy;
    }

    public DefaultOrmQuery<T> setOrderBy(String orderByClause) {
        return this.order(orderByClause);
    }

    @Override
    public DefaultOrmQuery<T> orderBy(String orderByClause) {
        return this.order(orderByClause);
    }

    @Override
    public DefaultOrmQuery<T> order(String orderByClause) {
        this.orderBy = orderByClause == null || orderByClause.trim().length() == 0 ? null : new OrderBy(this, orderByClause);
        return this;
    }

    @Override
    public DefaultOrmQuery<T> setOrderBy(OrderBy<T> orderBy) {
        return this.setOrder((OrderBy)orderBy);
    }

    @Override
    public DefaultOrmQuery<T> setOrder(OrderBy<T> orderBy) {
        this.orderBy = orderBy;
        if (orderBy != null) {
            orderBy.setQuery(this);
        }
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public DefaultOrmQuery<T> setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public boolean isDistinctQuery() {
        return this.distinct || this.sqlDistinct;
    }

    @Override
    public DefaultOrmQuery<T> setSqlDistinct(boolean sqlDistinct) {
        this.sqlDistinct = sqlDistinct;
        return this;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType;
    }

    @Override
    public void setDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    @Override
    public boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        return this.detail.tuneFetchProperties(tunedDetail);
    }

    @Override
    public OrmQueryDetail getDetail() {
        return this.detail;
    }

    @Override
    public final ArrayList<EntityBean> getContextAdditions() {
        return this.contextAdditions;
    }

    @Override
    public void contextAdd(EntityBean bean) {
        if (this.contextAdditions == null) {
            this.contextAdditions = new ArrayList();
        }
        this.contextAdditions.add(bean);
    }

    public String toString() {
        return "Query [" + this.whereExpressions + "]";
    }

    @Override
    public TableJoin getIncludeTableJoin() {
        return this.includeTableJoin;
    }

    @Override
    public void setIncludeTableJoin(TableJoin includeTableJoin) {
        this.includeTableJoin = includeTableJoin;
    }

    @Override
    public int getFirstRow() {
        return this.firstRow;
    }

    @Override
    public DefaultOrmQuery<T> setFirstRow(int firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public DefaultOrmQuery<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public DefaultOrmQuery<T> setMapKey(String mapKey) {
        this.mapKey = mapKey;
        return this;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public DefaultOrmQuery<T> setId(Object id) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        this.id = id;
        return this;
    }

    @Override
    public BindParams getBindParams() {
        return this.bindParams;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public DefaultOrmQuery<T> where(String addToWhereClause) {
        this.additionalWhere = this.additionalWhere == null ? addToWhereClause : this.additionalWhere + " " + addToWhereClause;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> where(Expression expression) {
        if (this.whereExpressions == null) {
            this.whereExpressions = new DefaultExpressionList(this, null);
        }
        this.whereExpressions.add(expression);
        return this;
    }

    @Override
    public ExpressionList<T> where() {
        if (this.whereExpressions == null) {
            this.whereExpressions = new DefaultExpressionList(this, null);
        }
        return this.whereExpressions;
    }

    @Override
    public ExpressionList<T> filterMany(String prop) {
        OrmQueryProperties chunk = this.detail.getChunk(prop, true);
        return chunk.filterMany(this);
    }

    @Override
    public void setFilterMany(String prop, ExpressionList<?> filterMany) {
        if (filterMany != null) {
            OrmQueryProperties chunk = this.detail.getChunk(prop, true);
            chunk.setFilterMany((SpiExpressionList)filterMany);
        }
    }

    @Override
    public DefaultOrmQuery<T> having(String addToHavingClause) {
        this.additionalHaving = this.additionalHaving == null ? addToHavingClause : this.additionalHaving + " " + addToHavingClause;
        return this;
    }

    @Override
    public DefaultOrmQuery<T> having(Expression expression) {
        if (this.havingExpressions == null) {
            this.havingExpressions = new DefaultExpressionList(this, null);
        }
        this.havingExpressions.add(expression);
        return this;
    }

    @Override
    public ExpressionList<T> having() {
        if (this.havingExpressions == null) {
            this.havingExpressions = new DefaultExpressionList(this, null);
        }
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getHavingExpressions() {
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getWhereExpressions() {
        return this.whereExpressions;
    }

    @Override
    public String getGeneratedSql() {
        return this.generatedSql;
    }

    @Override
    public void setGeneratedSql(String generatedSql) {
        this.generatedSql = generatedSql;
    }

    @Override
    public Query<T> setBufferFetchSizeHint(int bufferFetchSizeHint) {
        this.bufferFetchSizeHint = bufferFetchSizeHint;
        return this;
    }

    @Override
    public int getBufferFetchSizeHint() {
        return this.bufferFetchSizeHint;
    }

    @Override
    public void setBeanCollectionTouched(BeanCollectionTouched notify) {
        this.beanCollectionTouched = notify;
    }

    @Override
    public BeanCollectionTouched getBeanCollectionTouched() {
        return this.beanCollectionTouched;
    }

    @Override
    public List<Object> getIdList() {
        return this.partialIds;
    }

    @Override
    public void setIdList(List<Object> partialIds) {
        this.partialIds = partialIds;
    }

    @Override
    public boolean isFutureFetch() {
        return this.futureFetch;
    }

    @Override
    public void setFutureFetch(boolean backgroundFetch) {
        this.futureFetch = backgroundFetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCancelableQuery(CancelableQuery cancelableQuery) {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            this.cancelableQuery = cancelableQuery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            this.cancelled = true;
            if (this.cancelableQuery != null) {
                this.cancelableQuery.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        DefaultOrmQuery defaultOrmQuery = this;
        synchronized (defaultOrmQuery) {
            return this.cancelled;
        }
    }
}

