/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.text.json;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.text.json.PathStack;
import com.avaje.ebeaninternal.server.util.ArrayStack;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class WriteJson {
    private final SpiEbeanServer server;
    private final JsonGenerator generator;
    private final PathProperties pathProperties;
    private final PathStack pathStack = new PathStack();
    private final ArrayStack<Object> parentBeans = new ArrayStack();

    public WriteJson(SpiEbeanServer server, JsonGenerator generator, PathProperties pathProperties) {
        this.server = server;
        this.generator = generator;
        this.pathProperties = pathProperties;
    }

    public JsonGenerator gen() {
        return this.generator;
    }

    public boolean isParentBean(Object bean) {
        return !this.parentBeans.isEmpty() && this.parentBeans.contains(bean);
    }

    public void pushParentBeanMany(Object parentBean) {
        this.parentBeans.push(parentBean);
    }

    public void popParentBeanMany() {
        this.parentBeans.pop();
    }

    public void beginAssocOne(String key, Object bean) {
        this.parentBeans.push(bean);
        this.pathStack.pushPathKey(key);
    }

    public void endAssocOne() {
        this.parentBeans.pop();
        this.pathStack.pop();
    }

    public WriteBean createWriteBean(BeanDescriptor<?> desc, EntityBean bean) {
        if (this.pathProperties == null) {
            return new WriteBean(desc, bean);
        }
        boolean explicitAllProps = false;
        Set<String> currentIncludeProps = this.pathProperties.get((String)this.pathStack.peekWithNull());
        if (currentIncludeProps != null && ((explicitAllProps = currentIncludeProps.contains("*")) || currentIncludeProps.isEmpty())) {
            currentIncludeProps = null;
        }
        return new WriteBean(desc, explicitAllProps, currentIncludeProps, bean);
    }

    public Boolean includeMany(String key) {
        if (this.pathProperties != null) {
            String fullPath = this.pathStack.peekFullPath(key);
            return this.pathProperties.hasPath(fullPath);
        }
        return null;
    }

    public void toJson(String name, Collection<?> c) throws IOException {
        this.beginAssocMany(name);
        for (Object bean : c) {
            BeanDescriptor<?> d = this.getDescriptor(bean.getClass());
            d.jsonWrite(this, (EntityBean)bean, null);
        }
        this.endAssocMany();
    }

    private <T> BeanDescriptor<T> getDescriptor(Class<T> cls) {
        BeanDescriptor<T> d = this.server.getBeanDescriptor(cls);
        if (d == null) {
            throw new RuntimeException("No BeanDescriptor found for " + cls);
        }
        return d;
    }

    public void beginAssocMany(String key) throws IOException {
        this.pathStack.pushPathKey(key);
        this.generator.writeFieldName(key);
        this.generator.writeStartArray();
    }

    public void endAssocMany() throws IOException {
        this.pathStack.pop();
        this.generator.writeEndArray();
    }

    public void writeStartArray(String key) throws IOException {
        if (key != null) {
            this.generator.writeFieldName(key);
        }
        this.generator.writeStartArray();
    }

    public void writeStartObject(String key) throws IOException {
        if (key != null) {
            this.generator.writeFieldName(key);
        }
        this.generator.writeStartObject();
    }

    public void writeNull(String name) throws IOException {
        this.generator.writeNullField(name);
    }

    public void writeEndObject() throws IOException {
        this.generator.writeEndObject();
    }

    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    public static class WriteBean {
        final boolean explicitAllProps;
        final Set<String> currentIncludeProps;
        final BeanDescriptor<?> desc;
        final EntityBean currentBean;

        WriteBean(BeanDescriptor<?> desc, EntityBean currentBean) {
            this(desc, false, null, currentBean);
        }

        WriteBean(BeanDescriptor<?> desc, boolean explicitAllProps, Set<String> currentIncludeProps, EntityBean currentBean) {
            this.desc = desc;
            this.currentBean = currentBean;
            this.explicitAllProps = explicitAllProps;
            this.currentIncludeProps = currentIncludeProps;
        }

        private boolean isReferenceOnly() {
            return !this.explicitAllProps && this.currentIncludeProps == null && this.currentBean._ebean_getIntercept().isReference();
        }

        private boolean isIncludeProperty(BeanProperty prop) {
            if (this.explicitAllProps) {
                return true;
            }
            if (this.currentIncludeProps != null) {
                return this.currentIncludeProps.contains(prop.getName());
            }
            return this.currentBean._ebean_getIntercept().isLoadedProperty(prop.getPropertyIndex());
        }

        public void write(WriteJson writeJson) throws IOException {
            BeanProperty beanProp = this.desc.getIdProperty();
            if (beanProp != null && this.isIncludeProperty(beanProp)) {
                beanProp.jsonWrite(writeJson, this.currentBean);
            }
            if (!this.isReferenceOnly()) {
                int j;
                BeanProperty[] props = this.desc.propertiesNonTransient();
                for (j = 0; j < props.length; ++j) {
                    if (!this.isIncludeProperty(props[j])) continue;
                    props[j].jsonWrite(writeJson, this.currentBean);
                }
                props = this.desc.propertiesTransient();
                for (j = 0; j < props.length; ++j) {
                    if (!this.isIncludeProperty(props[j])) continue;
                    props[j].jsonWrite(writeJson, this.currentBean);
                }
            }
        }
    }
}

