/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.ModifyAwareIterator;
import com.avaje.ebeaninternal.server.type.ModifyAwareOwner;
import java.util.Collection;
import java.util.Iterator;

public class ModifyAwareCollection<E>
implements Collection<E> {
    protected final ModifyAwareOwner owner;
    protected final Collection<E> c;

    public ModifyAwareCollection(ModifyAwareOwner owner, Collection<E> c) {
        this.owner = owner;
        this.c = c;
    }

    public String toString() {
        return this.c.toString();
    }

    @Override
    public boolean add(E o) {
        if (this.c.add(o)) {
            this.owner.markAsModified();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E o : collection) {
            if (!this.c.add(o)) continue;
            this.owner.markAsModified();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        if (!this.c.isEmpty()) {
            this.owner.markAsModified();
        }
        this.c.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.c.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.c.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.c.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new ModifyAwareIterator<E>(this.owner, this.c.iterator());
    }

    @Override
    public boolean remove(Object o) {
        if (this.c.remove(o)) {
            this.owner.markAsModified();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object o : collection) {
            if (!this.c.remove(o)) continue;
            this.owner.markAsModified();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<E> it = this.c.iterator();
        while (it.hasNext()) {
            E o = it.next();
            if (collection.contains(o)) continue;
            it.remove();
            this.owner.markAsModified();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.c.size();
    }

    @Override
    public Object[] toArray() {
        return this.c.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.c.toArray(a);
    }
}

