/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public abstract class ScalarTypeBaseVarchar<T>
extends ScalarTypeBase<T> {
    public ScalarTypeBaseVarchar(Class<T> type) {
        super(type, false, 12);
    }

    public ScalarTypeBaseVarchar(Class<T> type, boolean jdbcNative, int jdbcType) {
        super(type, jdbcNative, jdbcType);
    }

    @Override
    public abstract String formatValue(T var1);

    @Override
    public abstract T parse(String var1);

    public abstract T convertFromDbString(String var1);

    public abstract String convertToDbString(T var1);

    @Override
    public void bind(DataBind b, T value) throws SQLException {
        if (value == null) {
            b.setNull(12);
        } else {
            b.setString(this.convertToDbString(value));
        }
    }

    @Override
    public T read(DataReader dataReader) throws SQLException {
        String s = dataReader.getString();
        if (s == null) {
            return null;
        }
        return this.convertFromDbString(s);
    }

    @Override
    public T toBeanType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.parse((String)value);
        }
        return (T)value;
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof String) {
            return this.parse((String)value);
        }
        return value;
    }

    @Override
    public T convertFromMillis(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public String format(Object v) {
        return this.formatValue(v);
    }

    @Override
    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        String val = dataInput.readUTF();
        return this.convertFromDbString(val);
    }

    @Override
    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            String s = this.convertToDbString(value);
            dataOutput.writeUTF(s);
        }
    }

    @Override
    public T jsonRead(JsonParser ctx, JsonToken event) throws IOException {
        return this.parse(ctx.getValueAsString());
    }

    @Override
    public void jsonWrite(JsonGenerator ctx, String name, T value) throws IOException {
        ctx.writeStringField(name, this.format(value));
    }
}

