/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.ScalarTypeBase;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeByte
extends ScalarTypeBase<Byte> {
    public ScalarTypeByte() {
        super(Byte.class, true, -6);
    }

    @Override
    public void bind(DataBind b, Byte value) throws SQLException {
        if (value == null) {
            b.setNull(-6);
        } else {
            b.setByte(value);
        }
    }

    @Override
    public Byte read(DataReader dataReader) throws SQLException {
        return dataReader.getByte();
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toByte(value);
    }

    @Override
    public Byte toBeanType(Object value) {
        return BasicTypeConverter.toByte(value);
    }

    @Override
    public void jsonWrite(JsonGenerator ctx, String name, Byte value) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public Byte jsonRead(JsonParser ctx, JsonToken event) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public String formatValue(Byte t) {
        return t.toString();
    }

    @Override
    public Byte parse(String value) {
        throw new TextException("Not supported");
    }

    @Override
    public Byte convertFromMillis(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public Byte readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readByte();
    }

    @Override
    public void writeData(DataOutput dataOutput, Byte val) throws IOException {
        if (val == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeByte(val.byteValue());
        }
    }
}

