/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.core.BasicTypeConverter;
import com.avaje.ebeaninternal.server.type.ScalarTypeBaseDate;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class ScalarTypeLocalDate
extends ScalarTypeBaseDate<LocalDate> {
    public ScalarTypeLocalDate() {
        super(LocalDate.class, false, 91);
    }

    @Override
    public long convertToMillis(LocalDate value) {
        ZonedDateTime zonedDateTime = value.atStartOfDay(ZoneId.systemDefault());
        return zonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public LocalDate convertFromDate(Date ts) {
        return ts.toLocalDate();
    }

    @Override
    public Date convertToDate(LocalDate t) {
        return Date.valueOf(t);
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public LocalDate toBeanType(Object value) {
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDate convertFromMillis(long systemTimeMillis) {
        return new Timestamp(systemTimeMillis).toLocalDateTime().toLocalDate();
    }
}

