/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.FetchConfig;
import com.avaje.ebean.Filter;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.OrderBy;
import com.avaje.ebean.PagedList;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebean.util.ClassUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import org.jetbrains.annotations.Nullable;

@MappedSuperclass
public abstract class Model {
    public static EbeanServer db() {
        return Ebean.getDefaultServer();
    }

    public static EbeanServer db(String server) {
        return Ebean.getServer(server);
    }

    public void markAsDirty() {
        Model.db().markAsDirty(this);
    }

    public void markPropertyUnset(String propertyName) {
        ((EntityBean)((Object)this))._ebean_getIntercept().setPropertyLoaded(propertyName, false);
    }

    public void save() {
        Model.db().save(this);
    }

    public void update() {
        Model.db().update(this);
    }

    public void insert() {
        Model.db().insert(this);
    }

    public void delete() {
        Model.db().delete(this);
    }

    public void update(String server) {
        Model.db(server).update(this);
    }

    public void insert(String server) {
        Model.db(server).insert(this);
    }

    public void delete(String server) {
        Model.db(server).delete(this);
    }

    public void refresh() {
        Model.db().refresh(this);
    }

    public static abstract class Find<I, T> {
        private final Class<T> type;
        private final String serverName;

        public Find() {
            this.serverName = null;
            this.type = ClassUtil.getSecondArgumentType(this.getClass());
        }

        protected Find(String serverName, Class<T> type) {
            this.serverName = serverName;
            this.type = type;
        }

        public EbeanServer db() {
            return Ebean.getServer(this.serverName);
        }

        public EbeanServer db(String server) {
            return Ebean.getServer(server);
        }

        public Finder<I, T> on(String server) {
            return new Finder(server, this.type);
        }

        public void deleteById(I id) {
            this.db().delete(this.type, id);
        }

        public List<T> all() {
            return this.findList();
        }

        @Nullable
        public T byId(I id) {
            return this.db().find(this.type, id);
        }

        public T ref(I id) {
            return this.db().getReference(this.type, id);
        }

        public Filter<T> filter() {
            return this.db().filter(this.type);
        }

        public Query<T> query() {
            return this.db().find(this.type);
        }

        public Query<T> apply(PathProperties pathProperties) {
            return this.db().find(this.type).apply(pathProperties);
        }

        public I nextId() {
            return (I)this.db().nextId(this.type);
        }

        public List<Object> findIds() {
            return this.query().findIds();
        }

        public void findEach(QueryEachConsumer<T> consumer) {
            this.query().findEach(consumer);
        }

        public void findEachWhile(QueryEachWhileConsumer<T> consumer) {
            this.query().findEachWhile(consumer);
        }

        public List<T> findList() {
            return this.query().findList();
        }

        public Set<T> findSet() {
            return this.query().findSet();
        }

        public Map<?, T> findMap() {
            return this.query().findMap();
        }

        public <K> Map<K, T> findMap(String keyProperty, Class<K> keyType) {
            return this.query().findMap(keyProperty, keyType);
        }

        public PagedList<T> findPagedList(int pageIndex, int pageSize) {
            return this.query().findPagedList(pageIndex, pageSize);
        }

        public FutureRowCount<T> findFutureRowCount() {
            return this.query().findFutureRowCount();
        }

        public int findRowCount() {
            return this.query().findRowCount();
        }

        public ExpressionFactory getExpressionFactory() {
            return this.query().getExpressionFactory();
        }

        public Query<T> select(String fetchProperties) {
            return this.query().select(fetchProperties);
        }

        public Query<T> fetch(String path) {
            return this.query().fetch(path);
        }

        public Query<T> fetch(String path, FetchConfig joinConfig) {
            return this.query().fetch(path, joinConfig);
        }

        public Query<T> fetch(String path, String fetchProperties) {
            return this.query().fetch(path, fetchProperties);
        }

        public Query<T> fetch(String assocProperty, String fetchProperties, FetchConfig fetchConfig) {
            return this.query().fetch(assocProperty, fetchProperties, fetchConfig);
        }

        public ExpressionList<T> where() {
            return this.query().where();
        }

        public OrderBy<T> order() {
            return this.query().order();
        }

        public Query<T> order(String orderByClause) {
            return this.query().order(orderByClause);
        }

        public OrderBy<T> orderBy() {
            return this.query().orderBy();
        }

        public Query<T> orderBy(String orderByClause) {
            return this.query().orderBy(orderByClause);
        }

        public Query<T> setFirstRow(int firstRow) {
            return this.query().setFirstRow(firstRow);
        }

        public Query<T> setMaxRows(int maxRows) {
            return this.query().setMaxRows(maxRows);
        }

        public Query<T> setId(Object id) {
            return this.query().setId(id);
        }

        public Query<T> setQuery(String oql) {
            return this.db().createQuery(this.type, oql);
        }

        public Query<T> setRawSql(RawSql rawSql) {
            return this.query().setRawSql(rawSql);
        }

        public Query<T> setAutoTune(boolean autoTune) {
            return this.query().setAutoTune(autoTune);
        }

        public Query<T> setForUpdate(boolean forUpdate) {
            return this.query().setForUpdate(forUpdate);
        }

        public Query<T> setReadOnly(boolean readOnly) {
            return this.query().setReadOnly(readOnly);
        }

        public Query<T> setLoadBeanCache(boolean loadBeanCache) {
            return this.query().setLoadBeanCache(loadBeanCache);
        }

        public Query<T> setUseCache(boolean useBeanCache) {
            return this.query().setUseCache(useBeanCache);
        }

        public Query<T> setUseQueryCache(boolean useQueryCache) {
            return this.query().setUseQueryCache(useQueryCache);
        }
    }

    public static class Finder<I, T>
    extends Find<I, T> {
        public Finder(Class<T> type) {
            super(null, type);
        }

        public Finder(String serverName, Class<T> type) {
            super(serverName, type);
        }

        public Finder(Class<I> idType, Class<T> type) {
            super(null, type);
        }

        public Finder(String serverName, Class<I> idType, Class<T> type) {
            super(serverName, type);
        }
    }
}

