/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.AutoTuneMode;
import com.avaje.ebean.config.PropertiesWrapper;

public class AutoTuneConfig {
    private AutoTuneMode mode = AutoTuneMode.DEFAULT_ON;
    private String queryTuningFile = "ebean-autotune.xml";
    private boolean queryTuning;
    private boolean queryTuningAddVersion;
    private boolean profiling;
    private String profilingFile = "ebean-profiling";
    private int profilingBase = 5;
    private double profilingRate = 0.01;
    private int garbageCollectionWait = 100;
    private boolean skipCollectionOnShutdown;

    public String getQueryTuningFile() {
        return this.queryTuningFile;
    }

    public void setQueryTuningFile(String queryTuningFile) {
        this.queryTuningFile = queryTuningFile;
    }

    public String getProfilingFile() {
        return this.profilingFile;
    }

    public void setProfilingFile(String profilingFile) {
        this.profilingFile = profilingFile;
    }

    public AutoTuneMode getMode() {
        return this.mode;
    }

    public void setMode(AutoTuneMode mode) {
        this.mode = mode;
    }

    public boolean isQueryTuning() {
        return this.queryTuning;
    }

    public void setQueryTuning(boolean queryTuning) {
        this.queryTuning = queryTuning;
    }

    public boolean isQueryTuningAddVersion() {
        return this.queryTuningAddVersion;
    }

    public void setQueryTuningAddVersion(boolean queryTuningAddVersion) {
        this.queryTuningAddVersion = queryTuningAddVersion;
    }

    public boolean isProfiling() {
        return this.profiling;
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }

    public int getProfilingBase() {
        return this.profilingBase;
    }

    public void setProfilingBase(int profilingBase) {
        this.profilingBase = profilingBase;
    }

    public double getProfilingRate() {
        return this.profilingRate;
    }

    public void setProfilingRate(double profilingRate) {
        this.profilingRate = profilingRate;
    }

    public int getGarbageCollectionWait() {
        return this.garbageCollectionWait;
    }

    public void setGarbageCollectionWait(int garbageCollectionWait) {
        this.garbageCollectionWait = garbageCollectionWait;
    }

    public boolean isSkipCollectionOnShutdown() {
        return this.skipCollectionOnShutdown;
    }

    public void setSkipCollectionOnShutdown(boolean skipCollectionOnShutdown) {
        this.skipCollectionOnShutdown = skipCollectionOnShutdown;
    }

    public void loadSettings(PropertiesWrapper p) {
        this.queryTuning = p.getBoolean("autoTune.queryTuning", this.queryTuning);
        this.queryTuningAddVersion = p.getBoolean("autoTune.queryTuningAddVersion", this.queryTuningAddVersion);
        this.queryTuningFile = p.get("autoTune.queryTuningFile", this.queryTuningFile);
        this.skipCollectionOnShutdown = p.getBoolean("autoTune.skipCollectionOnShutdown", this.skipCollectionOnShutdown);
        this.mode = p.getEnum(AutoTuneMode.class, "autoTune.mode", this.mode);
        this.profiling = p.getBoolean("autoTune.profiling", this.profiling);
        this.profilingBase = p.getInt("autoTune.profilingBase", this.profilingBase);
        this.profilingRate = p.getDouble("autoTune.profilingRate", this.profilingRate);
        this.profilingFile = p.get("autoTune.profilingFile", this.profilingFile);
    }
}

