/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.config.PropertyMap;
import com.avaje.ebean.config.PropertyMapLoader;
import java.util.Properties;

public class PropertiesWrapper {
    protected final Properties properties;
    protected final String prefix;
    protected final String serverName;
    protected final PropertyMap propertyMap;

    public PropertiesWrapper(String prefix, String serverName, Properties properties) {
        this.serverName = serverName;
        this.prefix = prefix;
        this.propertyMap = PropertyMapLoader.load(null, properties);
        this.properties = this.propertyMap.asProperties();
    }

    public PropertiesWrapper(Properties properties) {
        this(null, null, properties);
    }

    protected PropertiesWrapper(String prefix, String serverName, PropertyMap propertyMap, Properties properties) {
        this.serverName = serverName;
        this.prefix = prefix;
        this.propertyMap = propertyMap;
        this.properties = properties;
    }

    public PropertiesWrapper withPrefix(String prefix) {
        return new PropertiesWrapper(prefix, this.serverName, this.propertyMap, this.properties);
    }

    public String getServerName() {
        return this.serverName;
    }

    public Properties asPropertiesLowerCase() {
        return this.properties;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String value = null;
        if (this.serverName != null && this.prefix != null) {
            value = this.propertyMap.get(this.prefix + "." + this.serverName + "." + key, null);
        }
        if (value == null && this.prefix != null) {
            value = this.propertyMap.get(this.prefix + "." + key, null);
        }
        if (value == null) {
            value = this.propertyMap.get(key, null);
        }
        return value == null ? defaultValue : value;
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Double.parseDouble(value);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Integer.parseInt(value);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Long.parseLong(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumType, String key, T defaultValue) {
        String level = this.get(key, defaultValue.name());
        return Enum.valueOf(enumType, level.toUpperCase());
    }
}

