/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

public class DbType {
    public static final int UUID = 5010;
    public static final int HSTORE = 5000;
    public static final int JSON = 5001;
    public static final int JSONB = 5002;
    public static final int JSONVarchar = 5003;
    public static final int JSONClob = 5004;
    public static final int JSONBlob = 5005;
    private final String name;
    private final int defaultLength;
    private final int defaultScale;
    private final boolean canHaveLength;

    public DbType(String name) {
        this(name, 0, 0);
    }

    public DbType(String name, int defaultLength) {
        this(name, defaultLength, 0);
    }

    public DbType(String name, int defaultPrecision, int defaultScale) {
        this.name = name;
        this.defaultLength = defaultPrecision;
        this.defaultScale = defaultScale;
        this.canHaveLength = true;
    }

    public DbType(String name, boolean canHaveLength) {
        this.name = name;
        this.defaultLength = 0;
        this.defaultScale = 0;
        this.canHaveLength = canHaveLength;
    }

    public String renderType(int deployLength, int deployScale) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.canHaveLength) {
            int len;
            int n = len = deployLength != 0 ? deployLength : this.defaultLength;
            if (len > 0) {
                int scale;
                sb.append("(");
                sb.append(len);
                int n2 = scale = deployScale != 0 ? deployScale : this.defaultScale;
                if (scale > 0) {
                    sb.append(",");
                    sb.append(scale);
                }
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

