/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.DbMigrationConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DB2Platform;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbPlatformName;
import com.avaje.ebean.config.dbplatform.H2Platform;
import com.avaje.ebean.config.dbplatform.MsSqlServer2005Platform;
import com.avaje.ebean.config.dbplatform.MySqlPlatform;
import com.avaje.ebean.config.dbplatform.OraclePlatform;
import com.avaje.ebean.config.dbplatform.PostgresPlatform;
import com.avaje.ebean.config.dbplatform.SQLitePlatform;
import com.avaje.ebean.dbmigration.DbOffline;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.migration.Migration;
import com.avaje.ebean.dbmigration.migrationreader.MigrationXmlWriter;
import com.avaje.ebean.dbmigration.model.CurrentModel;
import com.avaje.ebean.dbmigration.model.MConfiguration;
import com.avaje.ebean.dbmigration.model.MigrationModel;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import com.avaje.ebean.dbmigration.model.ModelDiff;
import com.avaje.ebean.dbmigration.model.PlatformDdlWriter;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigration {
    protected static final Logger logger = LoggerFactory.getLogger(DbMigration.class);
    protected SpiEbeanServer server;
    protected DbMigrationConfig migrationConfig;
    protected String pathToResources = "src/main/resources";
    protected DatabasePlatform databasePlatform;
    protected List<Pair> platforms = new ArrayList<Pair>();
    protected ServerConfig serverConfig;
    protected DbConstraintNaming constraintNaming;

    public void setPathToResources(String pathToResources) {
        this.pathToResources = pathToResources;
    }

    public void setServer(EbeanServer ebeanServer) {
        this.server = (SpiEbeanServer)ebeanServer;
        this.setServerConfig(this.server.getServerConfig());
    }

    public void setServerConfig(ServerConfig config) {
        if (this.serverConfig == null) {
            this.serverConfig = config;
        }
        if (this.migrationConfig == null) {
            this.migrationConfig = this.serverConfig.getMigrationConfig();
        }
        if (this.constraintNaming == null) {
            this.constraintNaming = this.serverConfig.getConstraintNaming();
        }
    }

    public void setPlatform(DbPlatformName platform) {
        this.setPlatform(this.getPlatform(platform));
    }

    public void setPlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
        DbOffline.setPlatform(databasePlatform.getName());
    }

    public void addPlatform(DbPlatformName platform, String prefix) {
        if (!prefix.endsWith("-")) {
            prefix = prefix + "-";
        }
        this.platforms.add(new Pair(this.getPlatform(platform), prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateMigration() throws IOException {
        DbOffline.setRunningMigration();
        this.setDefaults();
        try {
            MigrationModel migrationModel = new MigrationModel(this.migrationConfig.getResourcePath());
            ModelContainer migrated = migrationModel.read();
            int nextMajorVersion = migrationModel.getNextMajorVersion();
            logger.info("next migration version {}", (Object)nextMajorVersion);
            CurrentModel currentModel = new CurrentModel(this.server, this.constraintNaming);
            ModelContainer current = currentModel.read();
            ModelDiff diff = new ModelDiff(migrated);
            diff.compareTo(current);
            if (diff.isEmpty()) {
                logger.info("no changes detected - no migration written");
                return;
            }
            Migration dbMigration = diff.getMigration();
            File writePath = this.getWritePath();
            logger.info("migration writing version {} to {}", (Object)nextMajorVersion, (Object)writePath.getAbsolutePath());
            this.writeMigrationXml(dbMigration, writePath, nextMajorVersion);
            if (this.databasePlatform != null) {
                DdlWrite write = new DdlWrite(new MConfiguration(), currentModel.read());
                PlatformDdlWriter writer = new PlatformDdlWriter(this.databasePlatform, this.serverConfig);
                writer.processMigration(dbMigration, write, writePath, nextMajorVersion);
            }
            this.writeExtraPlatformDdl(nextMajorVersion, currentModel, dbMigration, writePath);
        }
        finally {
            DbOffline.reset();
        }
    }

    protected void writeExtraPlatformDdl(int nextMajorVersion, CurrentModel currentModel, Migration dbMigration, File writePath) throws IOException {
        for (Pair pair : this.platforms) {
            DdlWrite platformBuffer = new DdlWrite(new MConfiguration(), currentModel.read());
            PlatformDdlWriter platformWriter = new PlatformDdlWriter(pair.platform, this.serverConfig, pair.prefix);
            platformWriter.processMigration(dbMigration, platformBuffer, writePath, nextMajorVersion);
        }
    }

    protected void writeMigrationXml(Migration dbMigration, File resourcePath, int migrationVersion) {
        File file = new File(resourcePath, "v" + migrationVersion + ".0.xml");
        MigrationXmlWriter xmlWriter = new MigrationXmlWriter();
        xmlWriter.write(dbMigration, file);
    }

    protected void setDefaults() {
        if (this.server == null) {
            this.setServer(Ebean.getDefaultServer());
        }
        if (this.databasePlatform == null && this.platforms.isEmpty()) {
            this.databasePlatform = this.server.getDatabasePlatform();
            logger.debug("set platform to {}", (Object)this.databasePlatform.getName());
        }
    }

    protected File getWritePath() {
        File resourceRootDir = new File(this.pathToResources);
        String resourcePath = this.migrationConfig.getResourcePath();
        File path = new File(resourceRootDir, resourcePath);
        if (!path.exists() && !path.mkdirs()) {
            logger.debug("Unable to ensure migration directory exists at {}", (Object)path.getAbsolutePath());
        }
        return path;
    }

    protected DatabasePlatform getPlatform(DbPlatformName platform) {
        switch (platform) {
            case H2: {
                return new H2Platform();
            }
            case POSTGRES: {
                return new PostgresPlatform();
            }
            case MYSQL: {
                return new MySqlPlatform();
            }
            case ORACLE: {
                return new OraclePlatform();
            }
            case SQLSERVER: {
                return new MsSqlServer2005Platform();
            }
            case DB2: {
                return new DB2Platform();
            }
            case SQLITE: {
                return new SQLitePlatform();
            }
        }
        throw new IllegalArgumentException("Platform missing? " + (Object)((Object)platform));
    }

    public static class Pair {
        public final DatabasePlatform platform;
        public final String prefix;

        public Pair(DatabasePlatform platform, String prefix) {
            this.platform = platform;
            this.prefix = prefix;
        }
    }
}

