/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration;

import com.avaje.ebean.config.dbplatform.DbPlatformName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbOffline {
    private static final Logger logger = LoggerFactory.getLogger(DbOffline.class);
    private static final String KEY = "ebean.dboffline";
    private static boolean runningMigration;

    public static void setPlatform(DbPlatformName dbPlatform) {
        System.setProperty(KEY, dbPlatform.name());
    }

    public static void setPlatform(String platformName) {
        System.setProperty(KEY, platformName);
    }

    public static String getPlatform() {
        return System.getProperty(KEY);
    }

    public static void asH2() {
        DbOffline.setPlatform(DbPlatformName.H2);
    }

    public static boolean isSet() {
        return DbOffline.getPlatform() != null;
    }

    public static boolean isRunningMigration() {
        return runningMigration;
    }

    public static void setRunningMigration() {
        runningMigration = true;
    }

    public static void reset() {
        runningMigration = false;
        System.clearProperty(KEY);
        logger.debug("reset");
    }
}

