/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import com.avaje.ebean.dbmigration.migration.AddHistoryTable;
import com.avaje.ebean.dbmigration.migration.DropHistoryTable;
import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class DbTriggerBasedHistoryDdl
implements PlatformHistoryDdl {
    protected DbConstraintNaming constraintNaming;
    protected PlatformDdl platformDdl;
    protected String sysPeriod;
    protected String sysPeriodStart;
    protected String sysPeriodEnd;
    protected String viewSuffix;
    protected String historySuffix;
    protected String currentTimestamp = "now(6)";
    protected String sysPeriodType = "datetime(6)";

    @Override
    public void configure(ServerConfig serverConfig, PlatformDdl platformDdl) {
        this.platformDdl = platformDdl;
        this.sysPeriod = serverConfig.getAsOfSysPeriod();
        this.viewSuffix = serverConfig.getAsOfViewSuffix();
        this.historySuffix = serverConfig.getHistoryTableSuffix();
        this.constraintNaming = serverConfig.getConstraintNaming();
        this.sysPeriodStart = this.sysPeriod + "_start";
        this.sysPeriodEnd = this.sysPeriod + "_end";
    }

    @Override
    public void regenerateHistoryTriggers(DdlWrite writer, HistoryTableUpdate update) throws IOException {
        MTable table = writer.getTable(update.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("MTable " + update.getBaseTable() + " not found in writer? (required for history DDL)");
        }
        this.regenerateHistoryTriggers(writer, table, update);
    }

    protected abstract void regenerateHistoryTriggers(DdlWrite var1, MTable var2, HistoryTableUpdate var3) throws IOException;

    @Override
    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        String baseTable = dropHistoryTable.getBaseTable();
        this.dropTriggers(writer.dropHistory(), baseTable);
        this.dropHistoryTableEtc(writer.dropHistory(), baseTable);
    }

    @Override
    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        String baseTable = addHistoryTable.getBaseTable();
        MTable table = writer.getTable(baseTable);
        if (table == null) {
            throw new IllegalStateException("MTable " + baseTable + " not found in writer? (required for history DDL)");
        }
        this.createWithHistory(writer, table);
    }

    @Override
    public void createWithHistory(DdlWrite writer, MTable table) throws IOException {
        String baseTable = table.getName();
        String whenCreatedColumn = table.getWhenCreatedColumn();
        this.dropTriggers(writer.rollback(), baseTable);
        this.dropHistoryTableEtc(writer.rollback(), baseTable);
        this.addHistoryTable(writer, table, whenCreatedColumn);
        this.addStoredFunction(writer, table, null);
        this.createTriggers(writer, table);
    }

    protected abstract void createTriggers(DdlWrite var1, MTable var2) throws IOException;

    protected abstract void dropTriggers(DdlBuffer var1, String var2) throws IOException;

    protected void addStoredFunction(DdlWrite writer, MTable table, HistoryTableUpdate update) throws IOException {
    }

    protected String normalise(String tableName) {
        return this.constraintNaming.normaliseTable(tableName);
    }

    protected String historyTableName(String baseTableName) {
        return this.normalise(baseTableName) + this.historySuffix;
    }

    protected String procedureName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_version";
    }

    protected String triggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_upd";
    }

    protected String updateTriggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_upd";
    }

    protected String deleteTriggerName(String baseTableName) {
        return this.normalise(baseTableName) + "_history_del";
    }

    protected void addHistoryTable(DdlWrite writer, MTable table, String whenCreatedColumn) throws IOException {
        String baseTableName = table.getName();
        DdlBuffer apply = writer.applyHistory();
        this.addSysPeriodColumns(apply, baseTableName, whenCreatedColumn);
        this.createHistoryTable(apply, table);
        this.createWithHistoryView(apply, baseTableName);
    }

    protected void addSysPeriodColumns(DdlBuffer apply, String baseTableName, String whenCreatedColumn) throws IOException {
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriodStart).append(" ").append(this.sysPeriodType).append(" default ").append(this.currentTimestamp).endOfStatement();
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriodEnd).append(" ").append(this.sysPeriodType).endOfStatement();
        if (whenCreatedColumn != null) {
            apply.append("update ").append(baseTableName).append(" set ").append(this.sysPeriodStart).append(" = ").append(whenCreatedColumn).endOfStatement();
        }
    }

    protected void createHistoryTable(DdlBuffer apply, MTable table) throws IOException {
        apply.append("create table ").append(table.getName()).append(this.historySuffix).append("(").newLine();
        Collection<MColumn> cols = table.getColumns().values();
        for (MColumn column : cols) {
            this.writeColumnDefinition(apply, column.getName(), column.getType());
            apply.append(",").newLine();
        }
        this.writeColumnDefinition(apply, this.sysPeriodStart, this.sysPeriodType);
        apply.append(",").newLine();
        this.writeColumnDefinition(apply, this.sysPeriodEnd, this.sysPeriodType);
        apply.newLine().append(")").endOfStatement();
    }

    protected void writeColumnDefinition(DdlBuffer buffer, String columnName, String type) throws IOException {
        String platformType = this.platformDdl.convert(type, false);
        buffer.append("  ");
        buffer.append(this.platformDdl.lowerColumnName(columnName), 29);
        buffer.append(platformType);
    }

    protected void createWithHistoryView(DdlBuffer apply, String baseTableName) throws IOException {
        apply.append("create view ").append(baseTableName).append(this.viewSuffix).append(" as select * from ").append(baseTableName).append(" union all select * from ").append(baseTableName).append(this.historySuffix).endOfStatement().end();
    }

    protected void dropHistoryTableEtc(DdlBuffer buffer, String baseTableName) throws IOException {
        buffer.append("drop view ").append(baseTableName).append(this.viewSuffix).endOfStatement();
        this.dropSysPeriodColumns(buffer, baseTableName);
        buffer.append("drop table ").append(baseTableName).append(this.historySuffix).endOfStatement().end();
    }

    protected void dropSysPeriodColumns(DdlBuffer buffer, String baseTableName) throws IOException {
        buffer.append("alter table ").append(baseTableName).append(" drop column ").append(this.sysPeriodStart).endOfStatement();
        buffer.append("alter table ").append(baseTableName).append(" drop column ").append(this.sysPeriodEnd).endOfStatement();
    }

    protected void appendInsertIntoHistory(DdlBuffer buffer, String historyTable, List<String> columns) throws IOException {
        buffer.append("    insert into ").append(historyTable).append(" (").append(this.sysPeriodStart).append(",").append(this.sysPeriodEnd).append(",");
        this.appendColumnNames(buffer, columns, "");
        buffer.append(") values (OLD.").append(this.sysPeriodStart).append(", ").append(this.currentTimestamp).append(",");
        this.appendColumnNames(buffer, columns, "OLD.");
        buffer.append(");").newLine();
    }

    protected void appendColumnNames(DdlBuffer buffer, List<String> columns, String columnPrefix) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columnPrefix);
            buffer.append(columns.get(i));
        }
    }

    protected List<String> includedColumnNames(MTable table) throws IOException {
        Collection<MColumn> columns = table.getColumns().values();
        ArrayList<String> includedColumns = new ArrayList<String>(columns.size());
        for (MColumn column : columns) {
            if (column.isHistoryExclude()) continue;
            includedColumns.add(column.getName());
        }
        return includedColumns;
    }
}

