/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import java.util.ArrayList;
import java.util.List;

public class HistoryTableUpdate {
    private final String baseTable;
    private final List<Column> columnChanges = new ArrayList<Column>();

    public HistoryTableUpdate(String baseTable) {
        this.baseTable = baseTable;
    }

    public String description() {
        StringBuilder sb = new StringBuilder(90);
        for (int i = 0; i < this.columnChanges.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.columnChanges.get(i).description());
        }
        return sb.toString();
    }

    public void toRevertedColumns(List<String> includedColumns) {
        for (Column columnChange : this.columnChanges) {
            columnChange.apply(includedColumns);
        }
    }

    public void add(Change change, String column) {
        this.columnChanges.add(new Column(change, column));
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public List<Column> getColumnChanges() {
        return this.columnChanges;
    }

    public static class Column {
        public final Change change;
        public final String column;

        public Column(Change change, String column) {
            this.change = change;
            this.column = column;
        }

        public String description() {
            return this.change.name().toLowerCase() + " " + this.column;
        }

        public void apply(List<String> includedColumns) {
            switch (this.change) {
                case ADD: 
                case INCLUDE: {
                    includedColumns.remove(this.column);
                    break;
                }
                case DROP: 
                case EXCLUDE: {
                    includedColumns.add(this.column);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected change " + (Object)((Object)this.change));
                }
            }
        }
    }

    public static enum Change {
        ADD,
        DROP,
        INCLUDE,
        EXCLUDE;

    }
}

